global Base BaseStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------

Mask=[MaskStr,'*.img']
NSess=2
SubIndVec=[3 4 5 6 7 9 10 11 12 13 14 15 16 17 18 20 21 22 23 24 25]
%SubIndVec=[14 16 17 20 22]
FemSubIndVec=[7 9 10 11 13 14 16 17 18 20 22]
MalSubIndVec=[3 4 5 6 12 15 21 23 24 25]
SubIndVec=SubIndVec
NSub=length(SubIndVec)
NSubSess=NSess.*NSub;
NSubSessOnes=ones(1,NSubSess)
for SubInd=1:NSub
    ActSubInd=SubIndVec(SubInd)
    if ActSubInd<10
        ActSubIndStr=['0',int2str(ActSubInd)]
    else
        ActSubIndStr=int2str(ActSubInd)
    end
    for SessInd=1:NSess
        if SessInd==1
            %FolderName=['D:\ValAro\',ActSubIndStr,'\s08_09\']
            FolderName=['K:\ValAro\',ActSubIndStr,'\09\']
        else
            %FolderName=['D:\ValAro\',ActSubIndStr,'\s08_36\']
            FolderName=['K:\ValAro\',ActSubIndStr,'\36\']
        end
        F=spm_get('Files',FolderName,Mask);
        RFile=spm_get('Files',FolderName,['realignment*'])
        R=ReadTxtMat(RFile,[6 406]);
        R=R';
        if size(R)~=[406,6]
            error('size(R)~=[406,6]')
        end
        eval(['F',int2str((SubInd-1).*NSess+SessInd),'=F'])
        eval(['R',int2str((SubInd-1).*NSess+SessInd),'=R;'])
    end
end

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         48.*ones(NSubSess,1), ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     1, ...
 'same_time_param',1, ...
 'nsess',          NSubSess, ...
 'nscans',         406.*ones(NSubSess,1), ...
 'files',          {{F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 F13 F14 F15 F16 F17 F18 F19 F20 F21 F22 ...
                    F21 F22 F23 F24 F25 F26 F27 F28 F29 F30 F31 F32 F33 F34 F35 F36 F37 F38 F39 F40 ...
                    F41 F42 ...
                     }}, ...
 'conditions_nb',  5.*NSubSessOnes, ...     
 'conditions',     NSubSessOnes, ...
 'regressors_nb',  6.*NSubSessOnes, ...
 'regressors',     [1:NSubSess], ...
 'parametrics_type', {{'none','none','none','none','none','none','none','none','none','none', ...
                       'none','none','none','none','none','none','none','none','none','none','none','none', ...
                       'none','none','none','none','none','none','none','none','none','none', ...
                        'none','none','none','none','none','none','none','none','none','none', ...
                        'none','none', ...
                    }}, ...
 'parametrics',    [], ...
 'stochastics_flag',0.*NSubSessOnes, ...
 'stochastics',    []);
          
%F21 F22 F23 F24 F25 F26 F27 F28 F29 F30 F31 F32 F33 F34 F35 F36 F37 F38 F39 F40 ... 
 %                    
 
NScanPerBlock=4;
NReg=6;
NegHigh=[2 9  13 20 23 30 33 39 42 49 52 59 63 70 72 80 83 89 92 98 ]*NScanPerBlock+Base
NegLow =[4 8  12 19 22 28 34 40 43 50 53 60 65 67 74 79 82 87 95 100]*NScanPerBlock+Base
Neutral=[1 6  11 16 21 26 31 36 41 46 51 56 61 66 71 76 81 86 91 96 ]*NScanPerBlock+Base
PosSlow =[5 7  14 17 25 27 35 37 44 47 55 58 64 68 75 78 85 88 94 99 ]*NScanPerBlock+Base
PosHigh=[3 10 15 18 24 29 32 38 45 48 54 57 62 69 73 77 84 90 93 97 ]*NScanPerBlock+Base
%-------------------------------------------

conditions(1) = struct( ...
 'names',   {{'NegHigh','NegLow','Neutral','PosSlow','PosHigh'}}, ...
 'onsets',{{NegHigh,NegLow,Neutral,PosSlow,PosHigh}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ...  %'types',    {{'events','events','events','events','events'}}, ... 
 'bf_ep',   [1 1 1 1 1], ...                                        %'bf_ev',   [1 1 1 1 1], ...
 'volterra',  0, ...
 'variable_dur',0);
%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NScanPerBlock, ...
  'conv',  1, ...  
  'deriv', 0);

%bf_ev(1) = struct( ...
%  'ev_type',1, ...
%  'length',4);


regressors(1) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R1);
regressors(2) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R2);
regressors(3) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R3);
regressors(4) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R4);
regressors(5) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R5);
regressors(6) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R6);
regressors(7) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R7);
regressors(8) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R8);
regressors(9) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R9);
regressors(10) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R10);
regressors(11) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R11);
regressors(12) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R12);
regressors(13) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R13);
regressors(14) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R14);
regressors(15) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R15);
regressors(16) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R16);
regressors(17) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R17);
regressors(18) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R18);
regressors(19) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R19);
regressors(20) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R20);
regressors(21) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R21);
regressors(22) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R22);
regressors(23) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R23);
regressors(24) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R24);
regressors(25) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R25);
regressors(26) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R26);
regressors(27) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R27);
regressors(28) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R28);
regressors(29) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R29);
regressors(30) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R30);
regressors(31) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R31);
regressors(32) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R32);
regressors(33) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R33);
regressors(34) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R34);
regressors(35) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R35);
regressors(36) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R36);
regressors(37) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R37);
regressors(38) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R38);
regressors(39) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R39);
regressors(40) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R40);
regressors(41) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R41);
regressors(42) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R42);

NZeros=zeros(1,NSubSess)
%-------------------------------------------
%-------------All---------------------------
%-------------------------------------------
%-----------Arousal All---------------------
Tmp1=[0 0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNeutAll=[Tmp2 NZeros];
CPosHiLTNeutAll=-CPosHiGTNeutAll;

Tmp1=[1 0 -1 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTNeutAll=[Tmp2 NZeros];
CNegHiLTNeutAll=-CNegHiGTNeutAll;

Tmp1=[0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLoGTNeutAll=[Tmp2 NZeros];
CPosLoLTNeutAll=-CPosLoGTNeutAll;

Tmp1=[0 1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegLoGTNeutAll=[Tmp2 NZeros];
CNegLoLTNeutAll=-CNegLoGTNeutAll;

%-----------Valence All----------------------
Tmp1=[-1 0 0 0 1 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNegHiAll=[Tmp2 NZeros];
CPosHiLTNegHiAll=-CPosHiGTNegHiAll;

Tmp1=[0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLoGTNegLoAll=[Tmp2 NZeros];
CPosLoLTNegLoAll=-CPosLoGTNegLoAll;

%-------------------------------------------
%-----------Arousal Complex---------------------
Tmp1=[3 -2 -2 -2 3 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTLoAll=[Tmp2 NZeros];
CAroHiLTLoAll=-CAroHiGTLoAll;

Tmp1=[4 -1 -6 -1 4 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroLinHiGTLoAll=[Tmp2 NZeros];
CAroLinHiLTLoAll=-CAroLinHiGTLoAll;

Tmp1=[2 -1 -2 -1 2 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroExp1HiGTLoAll=[Tmp2 NZeros];
CAroExp1HiLTLoAll=-CAroExp1HiGTLoAll;

Tmp1=[7 -3 -8 -3 7 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroExp2HiGTLoAll=[Tmp2 NZeros];
CAroExp2HiLTLoAll=-CAroExp2HiGTLoAll;

%-------------------------------------------

%-----------Valence Complex---------------------
Tmp1=[-1 -1 0 1 1 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CValPosGTNegAll=[Tmp2 NZeros];
CValPosLTNegAll=-CValPosGTNegAll;

%-------------------------------------------
%-----------Slow--------------------------
%-------------------------------------------
%-----------Arousal Slow---------------------
Tmp1=[0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNeutSlow=[Tmp2 NZeros];
CPosHiLTNeutSlow=-CPosHiGTNeutSlow;

Tmp1=[1 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTNeutSlow=[Tmp2 NZeros];
CNegHiLTNeutSlow=-CNegHiGTNeutSlow;

Tmp1=[0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLoGTNeutSlow=[Tmp2 NZeros];
CPosLoLTNeutSlow=-CPosLoGTNeutSlow;

Tmp1=[0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegLoGTNeutSlow=[Tmp2 NZeros];
CNegLoLTNeutSlow=-CNegLoGTNeutSlow;

%-----------Valence Slow----------------------
Tmp1=[-1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNegHiSlow=[Tmp2 NZeros];
CPosHiLTNegHiSlow=-CPosHiGTNegHiSlow;

Tmp1=[0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLoGTNegLoSlow=[Tmp2 NZeros];
CPosLoLTNegLoSlow=-CPosLoGTNegLoSlow;

%-------------------------------------------
%-----------Arousal Slow Complex---------------------
Tmp1=[3 -2 -2 -2 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTLoSlow=[Tmp2 NZeros];
CAroHiLTLoSlow=-CAroHiGTLoSlow;

Tmp1=[4 -1 -6 -1 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroLinHiGTLoSlow=[Tmp2 NZeros];
CAroLinHiLTLoSlow=-CAroLinHiGTLoSlow;

Tmp1=[2 -1 -2 -1 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroExp1HiGTLoSlow=[Tmp2 NZeros];
CAroExp1HiLTLoSlow=-CAroExp1HiGTLoSlow;

Tmp1=[7 -3 -8 -3 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroExp2HiGTLoSlow=[Tmp2 NZeros];
CAroExp2HiLTLoSlow=-CAroExp2HiGTLoSlow;

%-------------------------------------------

%-----------Valence Slow Complex---------------------
Tmp1=[-1 -1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CValPosGTNegSlow=[Tmp2 NZeros];
CValPosLTNegSlow=-CValPosGTNegSlow;

%-------------------------------------------
%-----------Fast--------------------------
%-------------------------------------------
%-----------Arousal Fast---------------------
Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNeutFast=[Tmp2 NZeros];
CPosHiLTNeutFast=-CPosHiGTNeutFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTNeutFast=[Tmp2 NZeros];
CNegHiLTNeutFast=-CNegHiGTNeutFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLoGTNeutFast=[Tmp2 NZeros];
CPosLoLTNeutFast=-CPosLoGTNeutFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegLoGTNeutFast=[Tmp2 NZeros];
CNegLoLTNeutFast=-CNegLoGTNeutFast;

% CPosHiGTNeutFast=[];
% CNegHiGTNeutFast=[];
% CPosLoGTNeutFast=[];
% CNegLoGTNeutFast=[];

%-----------Valence Fast----------------------
Tmp1=[0 0 0 0 0 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNegHiFast=[Tmp2 NZeros];
CPosHiLTNegHiFast=-CPosHiGTNegHiFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLoGTNegLoFast=[Tmp2 NZeros];
CPosLoLTNegLoFast=-CPosLoGTNegLoFast;

%-------------------------------------------
%-----------Arousal Fast Complex---------------------
Tmp1=[0 0 0 0 0 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTLoFast=[Tmp2 NZeros];
CAroHiLTLoFast=-CAroHiGTLoFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroLinHiGTLoFast=[Tmp2 NZeros];
CAroLinHiLTLoFast=-CAroLinHiGTLoFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroExp1HiGTLoFast=[Tmp2 NZeros];
CAroExp1HiLTLoFast=-CAroExp1HiGTLoFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroExp2HiGTLoFast=[Tmp2 NZeros];
CAroExp2HiLTLoFast=-CAroExp2HiGTLoFast;

%-------------------------------------------
%-----------Valence Fast Complex---------------------
Tmp1=[0 0 0 0 0 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CValPosGTNegFast=[Tmp2 NZeros];
CValPosLTNegFast=-CValPosGTNegFast;

%-------------------------------------------
%-----------Fast Vs Slow--------------------
%-------------------------------------------
%-----------All Fast Vs Slow------------
Tmp1=[-1 -1 -1 -1 -1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowAll=[Tmp2 NZeros];
CFastLTSlowAll=-CFastGTSlowAll;

Tmp1=[-1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowNegHiAll=[Tmp2 NZeros];
CFastLTSlowNegHiAll=-CFastGTSlowNegHiAll;

Tmp1=[0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowNegLoAll=[Tmp2 NZeros];
CFastLTSlowNegLoAll=-CFastGTSlowNegLoAll;

Tmp1=[0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowNeutAll=[Tmp2 NZeros];
CFastLTSlowNeutAll=-CFastGTSlowNeutAll;

Tmp1=[0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowPosLoAll=[Tmp2 NZeros];
CFastLTSlowPosLoAll=-CFastGTSlowPosLoAll;

Tmp1=[0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowPosHiAll=[Tmp2 NZeros];
CFastLTSlowPosHiAll=-CFastGTSlowPosHiAll;

%-------------------------------------------
%-----------Arousal Fast Vs Slow------------
Tmp1=[-1 0 0 0 -1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowHiAroAll=[Tmp2 NZeros];
CFastLTSlowHiAroAll=-CFastGTSlowHiAroAll;

Tmp1=[0 -1 0 -1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowLoAroAll=[Tmp2 NZeros];
CFastLTSlowLoAroAll=-CFastGTSlowLoAroAll;

%-------------------------------------------
%-----------Valence Fast Vs Slow------------
Tmp1=[-1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowNegValAll=[Tmp2 NZeros];
CFastLTSlowNegValAll=-CFastGTSlowNegValAll;

Tmp1=[0 0 0 -1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CFastGTSlowPosValAll=[Tmp2 NZeros];
CFastLTSlowPosValAll=-CFastGTSlowPosValAll;

%-------------------------------------------
%-----------------PosHiPosLo----------------
Tmp1=[0 0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTPosLoAll=[Tmp2 NZeros];
CPosHiLTPosLoAll=-CPosHiGTPosLoAll;

Tmp1=[0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTPosLoSlow=[Tmp2 NZeros];
CPosHiLTPosLoSlow=-CPosHiGTPosLoSlow;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTPosLoFast=[Tmp2 NZeros];
CPosHiLTPosLoFast=-CPosHiGTPosLoFast;

%-------------------------------------------
%----------------NegHiNegLo-----------------
Tmp1=[1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTNegLoAll=[Tmp2 NZeros];
CNegHiLTNegLoAll=-CNegHiGTNegLoAll;

Tmp1=[1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTNegLoSlow=[Tmp2 NZeros];
CNegHiLTNegLoSlow=-CNegHiGTNegLoSlow;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTNegLoFast=[Tmp2 NZeros];
CNegHiLTNegLoFast=-CNegHiGTNegLoFast;

%-------------------------------------------
%--------------------PosHiNegLo-------------
Tmp1=[0 -1 0 0 1 0 0 0 0 0 0 0 -1 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNegLoAll=[Tmp2 NZeros];
CPosHiLTNegLoAll=-CPosHiGTNegLoAll;

Tmp1=[0 -1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNegLoSlow=[Tmp2 NZeros];
CPosHiLTNegLoSlow=-CPosHiGTNegLoSlow;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosHiGTNegLoFast=[Tmp2 NZeros];
CPosHiLTNegLoFast=-CPosHiGTNegLoFast;

%-------------------------------------------
%-------------------NegHiPosLo--------------
Tmp1=[1 0 0 -1 0 0 0 0 0 0 0 1 0 0 -1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTPosLoAll=[Tmp2 NZeros];
CNegHiLTPosLoAll=-CNegHiGTPosLoAll;

Tmp1=[1 0 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTPosLoSlow=[Tmp2 NZeros];
CNegHiLTPosLoSlow=-CNegHiGTPosLoSlow;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 1 0 0 -1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNegHiGTPosLoFast=[Tmp2 NZeros];
CNegHiLTPosLoFast=-CNegHiGTPosLoFast;

%-------------------------------------------
Tmp1=[1 -1 0 -1 1 0 0 0 0 0 0 1 -1 0 -1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTLoNoNeutralAll=[Tmp2 NZeros];
CAroHiLTLoNoNeutralAll=-CAroHiGTLoNoNeutralAll;

Tmp1=[0 1 -2 1 0 0 0 0 0 0 0 0 1 -2 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroLoGTNeutralAll=[Tmp2 NZeros];
CAroLoLTNeutralAll=-CAroLoGTNeutralAll;

Tmp1=[1 -1 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTLoNoNeutralSlow=[Tmp2 NZeros];
CAroHiLTLoNoNeutralSlow=-CAroHiGTLoNoNeutralSlow;

Tmp1=[0 1 -2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroLoGTNeutralSlow=[Tmp2 NZeros];
CAroLoLTNeutralSlow=-CAroLoGTNeutralSlow;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 1 -1 0 -1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTLoNoNeutralFast=[Tmp2 NZeros];
CAroHiLTLoNoNeutralFast=-CAroHiGTLoNoNeutralFast;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 0 1 -2 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroLoGTNeutralFast=[Tmp2 NZeros];
CAroLoLTNeutralFast=-CAroLoGTNeutralFast;

Tmp1=[1 0 -2 0 1 0 0 0 0 0 0 1 0 -2 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTNeutralAll=[Tmp2 NZeros];
CAroHiLTNeutralAll=-CAroHiGTNeutralAll;

Tmp1=[1 0 -2 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTNeutralSlow=[Tmp2 NZeros];
CAroHiLTNeutralSlow=-CAroHiGTNeutralSlow;

Tmp1=[0 0 0 0 0 0 0 0 0 0 0 1 0 -2 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAroHiGTNeutralFast=[Tmp2 NZeros];
CAroHiLTNeutralFast=-CAroHiGTNeutralFast;


contrasts(1) = struct( ...
  'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...                            %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...                  %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal', ...
            'CFastLTSlowPosVal','CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoSlow','CPosHiGTPosLoSlow', ...              %90
            'CPosHiLTPosLoFast','CPosHiGTPosLoFast','CNegHiLTNegLoAll','CNegHiGTNegLoAll','CNegHiLTNegLoSlow', ...
            'CNegHiGTNegLoSlow','CNegHiLTNegLoFast','CNegHiGTNegLoFast','CPosHiLTNegLoAll','CPosHiGTNegLoAll', ...             %100
            'CPosHiLTNegLoSlow','CPosHiGTNegLoSlow','CPosHiLTNegLoFast','CPosHiGTNegLoFast','CNegHiLTPosLoAll', ...
            'CNegHiGTPosLoAll', 'CNegHiLTPosLoSlow','CNegHiGTPosLoSlow','CNegHiLTPosLoFast','CNegHiGTPosLoFast', ...            %110
            'CAroHiGTLoNoNeutralAll','CAroHiLTLoNoNeutralAll','CAroHiGTLoNoNeutralSlow','CAroHiLTLoNoNeutralSlow','CAroHiGTLoNoNeutralFast',...
            'CAroHiLTLoNoNeutralFast','CAroLoGTNeutralAll','CAroLoLTNeutralAll','CAroLoGTNeutralSlow','CAroLoLTNeutralSlow',...
            'CAroLoGTNeutralFast','CAroLoLTNeutralFast','CAroHiGTNeutralAll','CAroHiLTNeutralAll','CAroHiGTNeutralSlow',...
            'CAroHiLTNeutralSlow','CAroHiGTNeutralFast','CAroHiLTNeutralFast'}}, ...
  'types',   {{'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T'...
            }}, ...
  'values',  {{...
            CPosHiGTNeutAll,CPosHiLTNeutAll,CNegHiGTNeutAll,CNegHiLTNeutAll,CPosLoGTNeutAll,...
            CPosLoLTNeutAll,CNegLoGTNeutAll,CNegLoLTNeutAll,CPosHiGTNegHiAll,CPosHiLTNegHiAll,...                                   %10
            CPosLoGTNegLoAll,CPosLoLTNegLoAll,CAroHiGTLoAll,CAroHiLTLoAll,CAroLinHiGTLoAll,...
            CAroLinHiLTLoAll,CAroExp1HiGTLoAll,CAroExp1HiLTLoAll,CAroExp2HiGTLoAll,CAroExp2HiLTLoAll,...                            %20
            CValPosGTNegAll,CValPosLTNegAll,CPosHiGTNeutSlow,CPosHiLTNeutSlow,CNegHiGTNeutSlow,...
            CNegHiLTNeutSlow,CPosLoGTNeutSlow,CPosLoLTNeutSlow,CNegLoGTNeutSlow,CNegLoLTNeutSlow,...                                %30
            CPosHiGTNegHiSlow,CPosHiLTNegHiSlow,CPosLoGTNegLoSlow,CPosLoLTNegLoSlow,CAroHiGTLoSlow,...
            CAroHiLTLoSlow,CAroLinHiGTLoSlow,CAroLinHiLTLoSlow,CAroExp1HiGTLoSlow,CAroExp1HiLTLoSlow,...                            %40
            CAroExp2HiGTLoSlow,CAroExp2HiLTLoSlow,CValPosGTNegSlow,CValPosLTNegSlow,CPosHiGTNeutFast,...
            CPosHiLTNeutFast,CNegHiGTNeutFast,CNegHiLTNeutFast,CPosLoGTNeutFast,CPosLoLTNeutFast,...                                %50
            CNegLoGTNeutFast,CNegLoLTNeutFast,CPosHiGTNegHiFast,CPosHiLTNegHiFast,CPosLoGTNegLoFast,...
            CPosLoLTNegLoFast,CAroHiGTLoFast,CAroHiLTLoFast,CAroLinHiGTLoFast,CAroLinHiLTLoFast,...                                 %60
            CAroExp1HiGTLoFast,CAroExp1HiLTLoFast,CAroExp2HiGTLoFast,CAroExp2HiLTLoFast,CValPosGTNegFast,...
            CValPosLTNegFast,CFastGTSlowAll,CFastLTSlowAll,CFastGTSlowNegHiAll,CFastLTSlowNegHiAll,...                              %70
            CFastGTSlowNegLoAll,CFastLTSlowNegLoAll,CFastGTSlowNeutAll,CFastLTSlowNeutAll,CFastGTSlowPosLoAll,...
            CFastLTSlowPosLoAll,CFastGTSlowPosHiAll,CFastLTSlowPosHiAll,CFastGTSlowHiAroAll,CFastLTSlowHiAroAll,...                 %80
            CFastGTSlowLoAroAll,CFastLTSlowLoAroAll,CFastGTSlowNegValAll,CFastLTSlowNegValAll,CFastGTSlowPosValAll,...
            CFastLTSlowPosValAll,CPosHiLTPosLoAll,CPosHiGTPosLoAll,CPosHiLTPosLoSlow,CPosHiGTPosLoSlow, ...                         %90
            CPosHiLTPosLoFast,CPosHiGTPosLoFast,CNegHiLTNegLoAll,CNegHiGTNegLoAll,CNegHiLTNegLoSlow, ...                            
            CNegHiGTNegLoSlow,CNegHiLTNegLoFast,CNegHiGTNegLoFast,CPosHiLTNegLoAll,CPosHiGTNegLoAll, ...                            %100
            CPosHiLTNegLoSlow,CPosHiGTNegLoSlow,CPosHiLTNegLoFast,CPosHiGTNegLoFast,CNegHiLTPosLoAll, ...                          
            CNegHiGTPosLoAll,CNegHiLTPosLoSlow,CNegHiGTPosLoSlow,CNegHiLTPosLoFast,CNegHiGTPosLoFast, ...                           %110
            CAroHiGTLoNoNeutralAll,CAroHiLTLoNoNeutralAll,CAroHiGTLoNoNeutralSlow,CAroHiLTLoNoNeutralSlow,CAroHiGTLoNoNeutralFast,...
            CAroHiLTLoNoNeutralFast,CAroLoGTNeutralAll,CAroLoLTNeutralAll,CAroLoGTNeutralSlow,CAroLoLTNeutralSlow,...
            CAroLoGTNeutralFast,CAroLoLTNeutralFast,CAroHiGTNeutralAll,CAroHiLTNeutralAll,CAroHiGTNeutralSlow,...
            CAroHiLTNeutralSlow,CAroHiGTNeutralFast,CAroHiLTNeutralFast}} ...
);