global  Base MaskStr 
%---------------------------------------------------------------

% model(1) Low-Off vs High Off

%---------------------------------------------------------------

clear F1 F2 F3 F4
Mask=[MaskStr,'*.img']; 
FolderName=['E:\fMRIData\Sound\01\Sound1']; 
F1=spm_get('Files',FolderName,Mask); 
size(F1)
RealignFile1=spm_get('Files',FolderName,['realignment*.*'])
RealignMat1=ReadTxtMat(RealignFile1,[6 366]); 
RealignMat1=RealignMat1'; 
if size(RealignMat1)~=[366,6]
   error('size(RealignMat1)~=[366,6]')
end
FolderName=['E:\fMRIData\Sound\01\Sound2']; 
F2=spm_get('Files',FolderName,Mask);
size(F2)
RealignFile2=spm_get('Files',FolderName,['realignment*.*'])
RealignMat2=ReadTxtMat(RealignFile2,[6 366]); 
RealignMat2=RealignMat2'; 
if size(RealignMat2)~=[366,6]
   error('size(RealignMat2)~=[366,6]')
end
FolderName=['E:\fMRIData\Sound\02\Sound1']; 
F3=spm_get('Files',FolderName,Mask); 
size(F3)
RealignFile3=spm_get('Files',FolderName,['realignment*.*'])
RealignMat3=ReadTxtMat(RealignFile3,[6 366]); 
RealignMat3=RealignMat3'; 
if size(RealignMat3)~=[366,6]
   error('size(RealignMat3)~=[366,6]')
end
FolderName=['E:\fMRIData\Sound\02\Sound2']; 
F4=spm_get('Files',FolderName,Mask); 
size(F4)
RealignFile4=spm_get('Files',FolderName,['realignment*.*'])
RealignMat4=ReadTxtMat(RealignFile4,[6 366]); 
RealignMat4=RealignMat4'; 
if size(RealignMat4)~=[366,6]
   error('size(RealignMat4)~=[366,6]')
end
F1
F2
F3
F4
%---------------------------------------------------------------

% batch variables defined here for analysis 'model'

%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'Scaling'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [48 48 48 48], ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          4, ...
 'nscans',         [366 366 366 366], ...
 'files',          {{F1 F2 F3 F4}}, ...
 'conditions_nb',  [9 9 9 9], ...     
 'conditions',     [1 2 1 2], ...
 'regressors_nb',  [6 6 6 6], ...
 'regressors',     [1 2 3 4], ...
 'parametrics_type', {{'none','none','none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0 0 0], ...
 'stochastics',    []); 

 
NScanPerBlock=4; 
%============================================
PosTone1=	([3    14    25    32    40    52    60    66    79    84]-1)*NScanPerBlock+Base
NeutTone1=	([ 7    12    21    34    39    50    61    68    76    88]-1)*NScanPerBlock+Base 
NegTone1=	([4    16    24    30    43    48    57    70    75    86]-1)*NScanPerBlock+Base 

PosPic1=		([6    10    22    36    44    49    56    69    74    90]-1)*NScanPerBlock+Base
NeutPic1=	([2    18    26    28    42    46    58    72    80    85]-1)*NScanPerBlock+Base
NegPic1=		([ 8    13    20    33    38    54    62    64    78    82]-1)*NScanPerBlock+Base

PosPicTone1=	([ 9    17    19    29    37    47    63    71    77    87]-1)*NScanPerBlock+Base
NeutPicTone1=([ 5    15    23    31    45    53    55    65    73    83]-1)*NScanPerBlock+Base
NegPicTone1=	([1    11    27    35    41    51    59    67    81    89]-1)*NScanPerBlock+Base
%============================================
PosTone2=	([ 3    16    21    34    40    51    61    66    77    86]-1)*NScanPerBlock+Base
NeutTone2=	([ 6    12    25    30    39    52    58    69    75    88]-1)*NScanPerBlock+Base
NegTone2=	([7    14    22    33    43    48    57    70    79    84]-1)*NScanPerBlock+Base

PosPic2=		([8    10    24    31    44    47    56    71    73    90]-1)*NScanPerBlock+Base
NeutPic2=	([ 2    15    20    35    42    49    62    65    81    82]-1)*NScanPerBlock+Base
NegPic2=		([ 4    18    26    29    38    53    60    67    76    87]-1)*NScanPerBlock+Base

PosPicTone2=	([ 5    13    27    28    37    54    59    68    80    83]-1)*NScanPerBlock+Base
NeutPicTone2=([  9    17    23    32    45    46    55    72    78    85]-1)*NScanPerBlock+Base
NegPicTone2=	([ 1    11    19    36    41    50    63    64    74    89]-1)*NScanPerBlock+Base
%============================================

conditions(1) = struct( ...
 'names',   {{'PosTone1','NeutTone1','NegTone1','PosPic1',',NeutPic1','NegPic1','PosPicTone1','NeutPicTone1','NegPicTone1'}}, ...
 'onsets',{{PosTone1,NeutTone1,NegTone1,PosPic1,NeutPic1,NegPic1,PosPicTone1,NeutPicTone1,NegPicTone1}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs','epochs','epochs','epochs','epochs'}}, ...  
 'bf_ep',   [1 1 1 1 1 1 1 1 1], ...                                        
 'volterra',  0, ...
 'variable_dur',0); 

conditions(2) = struct( ...
 'names',   {{'PosTone2','NeutTone2','NegTone2','PosPic2',',NeutPic2','NegPic2','PosPicTone2','NeutPicTone2','NegPicTone2'}}, ...
 'onsets',{{PosTone2,NeutTone2,NegTone2,PosPic2,NeutPic2,NegPic2,PosPicTone2,NeutPicTone2,NegPicTone2}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs','epochs','epochs','epochs','epochs'}}, ...  
 'bf_ep',   [1 1 1 1 1 1 1 1 1], ...                                        
 'volterra',  0, ...
 'variable_dur',0); 
%-------------------------------------------
bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NScanPerBlock, ...
  'conv',  1, ...  
  'deriv', 0); 
%-------------------------------------------
%-------------------------------------------
regressors(1) = struct( ...
 	'names', {{'xSound1','ySound1','zSound1','PitchSound1','RollSound1','YawSound1'}}, ...
    'values',RealignMat1); 

regressors(2) = struct( ...
 	'names', {{'xSound2','ySound2','zSound2','PitchSound2','RollSound2','YawSound2'}}, ...
	'values',RealignMat2); 

regressors(3) = struct( ...
 	'names', {{'xSound3','ySound3','zSound3','PitchSound3','RollSound3','YawSound3'}}, ...
    'values',RealignMat3); 

regressors(4) = struct( ...
 	'names', {{'xSound4','ySound4','zSound4','PitchSound4','RollSound4','YawSound4'}}, ...
	'values',RealignMat4); 
%-------------------------------------------
%-------------------------------------------
%-------------------------------------------
return;