function [MMat,BMat,MFile,BFile]=Mni2Tal(FilePath,SaveMniStatus,SaveMlStatus,SaveBStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<4; SaveBStatus=1; end
if nargin<3; SaveMStatus=1; end
if nargin<2; SaveMniStatus=1; end
if nargin<1; FilePath=[]; end


[File,Path,FilePath]=ReadFilePath(FilePath,'*.mni','Choose a Mni file:');
if File==0; return; end
fid=fopen(FilePath,'r');
Start=0;
MniMat=[0 0 0];
NKo=0;
NKo=0;
while 1
   Line=fgetl(fid);
   disp(Line)
   if ~isempty(findstr(Line,'----')), break, end
end
while 1
   Line = fgetl(fid);
   disp(Line)
   if  isempty(Line) | ~isempty(findstr(Line,'table')), break, end
   NKo=NKo+1;
   Tmp=findstr(Line,')');
   Remainder=Line(Tmp+2:length(Line));
   [pxyz]=sscanf(Remainder,'%g')';
   if NKo==1
       MniMat(1,:)=pxyz(2:4);
   else
      MniMatTmp=zeros(NKo,3);
      MniMatTmp(1:NKo-1,:)=MniMat;
      MniMatTmp(NKo,:)=pxyz(2:4);
      MniMat=MniMatTmp;
   end
end
fclose(fid);
BMat=MniMat;
MMat=MniMat;
for i=1:NKo
	MMat(i,1)=0.88.*MniMat(i,1)-0.8;	%Meyer-Lindenberg
	MMat(i,2)=0.97.*MniMat(i,2)-3.32;
	MMat(i,3)=0.05.*MniMat(i,2)+0.88.*MniMat(i,3)-0.44;
	
	BMat(i,1)=0.99.*MniMat(i,1);	%Brett
	if MniMat(i,3)>=0
		BMat(i,2)=0.9688.*MniMat(i,2)+0.046.*MniMat(i,3);
		BMat(i,3)=-0.0485.*MniMat(i,2)+0.9189.*MniMat(i,3);
	else
		BMat(i,2)=0.9688.*MniMat(i,2)+0.042.*MniMat(i,3);
		BMat(i,3)=-0.0485.*MniMat(i,2)+0.839.*MniMat(i,3);
	end
end
MniMat=MniMat
MMat=round(MMat)
BMat=round(BMat)
if length(File)>3
   if strcmp(File(length(File)-3:length(File)),'.txt');
      MniFile=[File(1:length(File)-4),'.mni.txt'];
		BFile=[File(1:length(File)-4),'.btal.txt'];
		MFile=[File(1:length(File)-4),'.mtal.txt'];
   else
     	MniFile=[File,'.mni.txt'];
		BFile=[File,'.btal.txt'];
		MFile=[File,'.mtal.txt'];
	end
else
   MniFile=[File,'.mni.txt'];
	BFile=[File,'.btal.txt'];
	MFile=[File,'.mtal.txt'];
end
if SaveMniStatus
   fid=fopen([Path,MniFile],'w');
   for i=1:NKo
      fprintf(fid,'%g\t',MniMat(i,1));
      fprintf(fid,'%g\t',MniMat(i,2));
		fprintf(fid,'%g\n',MniMat(i,3));
   end
	fclose(fid);	
end
if SaveBStatus
   fid=fopen([Path,BFile],'w');
   for i=1:NKo
      fprintf(fid,'%g\t',BMat(i,1));
      fprintf(fid,'%g\t',BMat(i,2));
		fprintf(fid,'%g\n',BMat(i,3));
   end
	fclose(fid);	
end
if SaveMStatus
	fid=fopen([Path,MFile],'w');
   for i=1:NKo
      fprintf(fid,'%g\t',MMat(i,1));
      fprintf(fid,'%g\t',MMat(i,2));
		fprintf(fid,'%g\n',MMat(i,3));
   end
	fclose(fid);	
end
return
