function ReformatGV(FileMat);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%=========================================================================
%
%	ReformatGV
%
%	Markus Junghoefer	[2000]
%

%	
%	Function definition
% 
% 
%================================================================================
if nargin<1;FileMat=[];end

DimType=1;
Scale=1
Type=4
Offset=0
refslice=4
Descrip='spm_compatible'
Descrip2 = ['spm_compatible, acq-fix ref-slice ' int2str(refslice)];
Interp2Str='cubic';


[DefFilePath]=SetDefPath('r','*.*');
[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,'Get MRI file(s)');
if NFiles==0; return; end
SetDefPath('w',BatchFilePath);

for FileInd=1:NFiles
   [File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd)
   LengthFile=length(File);
   LengthPath=length(Path);
   if strcmp(File(LengthFile-2:LengthFile),'fun')
      DimType=2;
      Orient='Coronal'
      NDyn=72
      NDynBase=2
   	NSlice=7	
   	Resol=128
		FOV=180 
  		STh=6.5 
      Origin=[63 18 85; 0 0 0]
      Dim=[Resol NSlice Resol; Resol Resol NSlice]
      Vox=[FOV/Resol STh FOV/Resol; FOV/Resol FOV/Resol STh]
     	NDimDataStatus=1
      clear NDimData
		[NDimData,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16');
      [File,Path]=SepFilePath(FilePath);
      m=SizeDataMat(1);
     	[MkDirStatus,MkDirMsg]=mkdir(Path,File(4:5));
		if MkDirStatus==1;
			disp(['Make directory: ',[Path,File(4:5)],' !\n\n'])
		elseif MkDirStatus==2;
			disp(['Directory: ',[Path,File(4:5)],' allready exists !\n\n'])
		elseif MkDirStatus==0;
			MkDirStatus=MkDirStatus
			MkDirMsg=MkDirMsg
			return;
      end
      WritePath=[Path,File(4:5),FileSep]
      ExpFileStr=File(1:6);
   else
      NDimDataStatus=0
      NDyn=1
      NDynBase=0
      Resol=256
      NSeek=7904
      if strcmp(Path(LengthPath-3:LengthPath-1),'002')
         Orient='Sagital'
        	NSlice=60
			FOV=240
   		STh=3
         Origin=[30 167 162]
         ExpFileStr='Vol'
        	Dim=[NSlice Resol Resol]
         Vox=[STh FOV/Resol FOV/Resol]
      else
        	Orient='Coronal'
         NDyn=1
   		NDynBase=0
   		NSlice=7	
         FOV=180 
   		STh=6.5 
         Origin=[126 18 170]
         ExpFileStr='Cor'
        	Dim=[Resol NSlice Resol]
     		Vox=[FOV/Resol STh FOV/Resol]
       end
       a=find(Path==FileSep);
       WritePath=Path(1:a(length(a)-1));
   end
   FunMat=zeros(Dim(DimType,1));
	fprintf('Read data from file...\n\n');
	for DynInd=NDynBase+1:NDyn
		for SliceInd=1:NSlice
			if NDimDataStatus	%'Functional Coronal'
            Data=squeeze(NDimData(:,:,SliceInd,DynInd));
            if m~=Resol;
               if DynInd==1 & SliceInd==1
                  SizeDataMat(1,2)=[Resol,Resol];
                  fprintf(1,['m=',int2str(m),'; resol=',int2str(Resol),'; => interp2 of data'])
                  pause
               end
					Data=interp2(Data,linspace(1,m,Resol),linspace(1,m,Resol)',Interp2Str);
            end
            if DimType==1
               FunMat(:,SliceInd,:)=fliplr(Data');
            elseif DimType==2
               FunMat(:,:,SliceInd)=Data;
            end
			else
				Ind=(DynInd-1).*NSlice+SliceInd;
				if Ind<10
					File=['I.00',int2str(Ind)];
				elseif  Ind>9 & Ind<100
					File=['I.0',int2str(Ind)];
				elseif  Ind>99 & Ind<1000
					File=['I.',int2str(Ind)];
            end
           	FilePath=[Path,File];
  				[FileSize]=GetFileSize(FilePath);
				DataSize=FileSize-NSeek;
            m=round(sqrt(DataSize./2));
  				fid=fopen(FilePath,'r','ieee-be');
				SeekStatus=fseek(fid,NSeek,'bof');
				[Data,Count]=fread(fid,[m,m],'int16');
				fclose(fid);
            if m~=Resol;
               if DynInd==1
                  disp(['m=',int2str(m),'; resol=',int2str(Resol),'; => interp2 of data'])
               end
					Data=interp2(Data,linspace(1,m,Resol),linspace(1,m,Resol)',Interp2Str);
				end
				if Count~=m.^2;
					Count=Count
					M2=m.^2;
					error('Count~=m.^2 in ReformatGV')
				end
            if strcmp(Orient,'Coronal')
               if DimType==1
                  FunMat(:,SliceInd,:)=fliplr(Data);
               elseif DimType==2
                  FunMat(:,:,SliceInd)=fliplr(Data);
               end
				elseif strcmp(Orient,'Sagital')
               FunMat(NSlice-SliceInd+1,:,:)=flipud(fliplr(Data));
      		end
			end
      end%for SliceInd=1:NSlice
      if NDyn>1
			if DynInd<10+NDynBase
				File=[ExpFileStr,'0',int2str(DynInd-NDynBase)];
      	else 
         	File=[ExpFileStr,int2str(DynInd-NDynBase)];
      	end
      else
         File=ExpFileStr;
      end
      FilePath=[WritePath,File,'.img'];
      fprintf(1,'Write data to file...\n\n');
		disp(FilePath)
      fid=fopen(FilePath,'w','ieee-le');
      fwrite(fid,FunMat,'int16');
		fprintf(1,'\n\n')
		fprintf('End writing data to file...\n\n');	
		fclose(fid);	
		[s]=spm_hwrite(FilePath,Dim(DimType,:),Vox(DimType,:),Scale,Type,Offset,Origin(DimType,:),Descrip);
		if s~=348
			error('error writing header in reformatgv')
      end
      if DimType==2
         if DynInd==(NDynBase+1)
            P=char(FilePath);
         else
            P=char(P,FilePath);
         end
      end
  end%for DynInd=1:NDyn
  if DimType==2
     spm_slice_timing(P,[1 3 5 7 2 4 6],refslice,[(3-.14)/7,(3-.140)/7+.14]);
     FunMat=zeros(Dim(1,:));
      for DynInd=1:NDyn-NDynBase
         	FilePath=P(DynInd,:);
         	FilePathOld=FilePath;
            [File,Path]=SepFilePath(FilePath);
            FilePath=[Path,'a',File];
            delete([FilePath(1:length(FilePath)-3),'hdr'])
            delete([FilePath(1:length(FilePath)-3),'mat'])
  				fid=fopen(FilePath,'r','ieee-le');
            [Tmp,Count]=fread(fid,'int16');
            Tmp=reshape(Tmp,Dim(DimType,:));
            fclose(fid);
            for SliceInd=1:NSlice
               FunMat(:,SliceInd,:)=fliplr(squeeze(Tmp(:,:,SliceInd))');
            end
            fprintf(1,'Write data to file...\n\n');
				disp(FilePath)
				fprintf(1,'\n\n')
				fid=fopen(FilePath,'w','ieee-le');
            fwrite(fid,FunMat,'int16');
            fclose(fid);
				[s]=spm_hwrite(FilePath,Dim(1,:),Vox(1,:),Scale,Type,Offset,Origin(1,:),Descrip2);
				if s~=348
					error('error writing header in reformatgv')
            end
            delete(FilePathOld)
            delete([FilePathOld(1:length(FilePathOld)-3),'hdr'])
      end
   end
end%for FileInd=1:NFiles
DeleteFileMat(FileMat);
clear all
spm_bch('BatchAnaRealign')
return;
