function [ExistFilePathMat,NFilesExist,NotExistFilePathMat,NFilesNotExist]=SpmGetReadContrastsExample;
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%---------------------------------------------------------------
%Rename spm_get.m to spm_get.old and copy the new spm_get.m in the spm folder
%Adapt the BasePath (line 50) of this m-file to your spm stats folder system
%Save this file in a folder of your Matlab search path or use File/Set Path in order to add the m-file containing folder to your search path
%Define a new folder with last three letters specifying a contrast number you would like to analyse
%e.g. PosGTNeg_002 or NegGTPos_003 (since first contrast is f tested effect of interest do not use *001)
%Start spm and choose this specified folder as working directory
%Start e.g. Basic models and choose Simple t-test
%Click on m-File in the top menu of spm-get and pick this file (or any other file matrix specifying files)

%Given a spm working directory of PosGTNeg_002 this file would try to read the following files:

%F:\fMRI\StudyXYZ\01\Stats01Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\02\Stats02Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\03\Stats03Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\04\Stats04Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\05\Stats05Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\06\Stats06Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\07\Stats07Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\08\Stats08Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\09\Stats09Smooth15\con_0002.img
%F:\fMRI\StudyXYZ\10\Stats10Smooth15\con_0002.img

%---------------------------------------------------------------

ActPath=pwd;           
SubVec=[1:10];          %
NSub=length(SubVec);
Con=str2num(ActPath(length(ActPath)-2:length(ActPath)));
if Con>1 & Con<=9
    File=['con_000',int2str(Con),'.img'];
elseif Con>9 & Con<=99
    File=['con_00',int2str(Con),'.img'];
elseif Con>99 & Con<=999
    File=['con_0',int2str(Con),'.img'];
else
    error('Contrast not defined')
end
NFilesExist=0;
NFilesNotExist=0;
ExistFilePathMat=[];
NotExistFilePathMat=[];
for SubInd=1:NSub
    ActSub=SubVec(SubInd);
    ActSubStr=int2str(ActSub);
    if ActSub<10
        ActSubStr=['0',ActSubStr];
    end
    BasePath=['F:\fMRI\StudyXYZ\',ActSubStr,'\Stats',ActSubStr,'Smooth15\'];
    FilePath=[BasePath,File];
    FileExist=exist(FilePath,'file');
    if FileExist==2
        NFilesExist=NFilesExist+1;
        if NFilesExist==1
            ExistFilePathMat=char(FilePath);
        else
            ExistFilePathMat=char(ExistFilePathMat,FilePath);
        end
    else
        NFilesNotExist=NFilesNotExist+1;
        if NFilesNotExist==1
            NotExistFilePathMat=char(FilePath);
        else
            NotExistFilePathMat=char(NotExistFilePathMat,FilePath);
        end   
    end
end
fprintf(1,'%g existing files chosen:\n\n',NFilesExist)
disp(ExistFilePathMat)
fprintf(1,'\n\n')
fprintf(1,'%g not existing files chosen:\n\n',NFilesNotExist)
disp(NotExistFilePathMat)