function [NVec,QuartMat,QuartFilePath]=Vox2Quart(FilePathImg,SaveStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<2; SaveStatus=0; end
if nargin<1; FilePathImg=[]; end

if isempty(FilePathImg)
    DefFolder=['D:\MEG\FPP\Flucht']
    Mask=['*.img'];
    FilePathImg=spm_get(1,Mask,'Choose a "Write filtered" analyze file',DefFolder);
    FilePathExt=lower(FilePathImg(length(FilePathImg)-3:length(FilePathImg)));
    if strcmp(FilePathExt,'.hdr')
        FilePathImg=[FilePathImg(1:length(FilePathImg)-4),'.img'];
        FilePathExt='.img';
    end
    if ~strcmp(FilePathExt,'.img')
        error('Please choose an analyze .img format file.')
    end
end

FilePathHdr=[FilePathImg(1:length(FilePathImg)-3),'hdr'];

[Dim,Vox,Scale,Type,Offset,Origin,Descrip]=spm_hread(FilePathHdr);
ProdDim=prod(Dim);
if Type==2
    ImgDataFormat='ubit8';
elseif Type==3
    ImgDataFormat='ubit16';
elseif Type==16
    ImgDataFormat='float';
else
    error('Unknown Type')
end 

fprintf(1,'Read data from file...\n\n');
disp(FilePathImg)
fprintf(1,'\n\n')

fid=fopen(FilePathImg,'r','ieee-le');
[ImgMat,Count]=fread(fid,ProdDim,ImgDataFormat);
fclose(fid);
ImgMat=reshape(ImgMat,Dim);
[IndVec1,IndVec2,IndVec3]=Ind2Sub(Dim,find(abs(ImgMat)>1.5));
NInd=length(IndVec1);
if NInd>0
    QuartMat=zeros(NInd,7);
else
    QuartMat=[];
end
if SaveStatus
    QuartFilePath=[FilePathImg(1:length(FilePathImg)-4),'.quart'];
    fprintf(1,'Write data to file...\n\n');
    disp(QuartFilePath)
    fprintf(1,'\n\n')
    fidQuart=fopen(QuartFilePath,'w','ieee-le');
else
    QuartFilePath=[];
end
for i=1:NInd
    x=(IndVec1(i)-Origin(1)).*Vox(1);
    y=(IndVec2(i)-Origin(2)).*Vox(2);
    z=(IndVec3(i)-Origin(3)).*Vox(3);
    QuartMat(i,1:3)=[x y z];
    QuartMat(i,4)=ImgMat(IndVec1(i),IndVec2(i),IndVec3(i)).*Scale;
    if x>0 & y>0
        QuartMat(i,5)=1;
    elseif x>0 & y<0
        QuartMat(i,5)=2;
    elseif x<0 & y<0
        QuartMat(i,5)=3;
    elseif x<0 & y>0
        QuartMat(i,5)=4;
    end
    if y>0
        QuartMat(i,6)=1;
    elseif y<0
        QuartMat(i,6)=2;
    end
    if x>0
        QuartMat(i,7)=1;
    elseif x<0
        QuartMat(i,7)=2;
    end
    if SaveStatus
        fprintf(fidQuart,'%g\n',QuartMat(i,:)); 
    end
end
if SaveStatus
    fclose(fidQuart);
end
if NInd>0
    
    PosInd=find(QuartMat(:,4)>0);
    NegInd=find(QuartMat(:,4)<0);
    AllAbsN=NInd;
    AllPosN=length(PosInd);
    AllNegN=length(NegInd);
    AllSumAbs=sum(abs(QuartMat(:,4)));
    if AllPosN>0
        AllSumPos=sum(QuartMat(PosInd,4));
    else
        AllSumPos=0;
    end
    if AllNegN>0
        AllSumNeg=sum(QuartMat(NegInd,4));
    else
        AllSumNeg=0;
    end
    AllMax=max(QuartMat(:,4));
    AllMin=min(QuartMat(:,4));
    
    FrontRightInd=find(QuartMat(:,5)==1);
    FrontRightPosInd=find(QuartMat(:,5)==1 & QuartMat(:,4)>0);
    FrontRightNegInd=find(QuartMat(:,5)==1 & QuartMat(:,4)<0);
    FrontRightAbsN=length(FrontRightInd);
    FrontRightPosN=length(FrontRightPosInd);
    FrontRightNegN=length(FrontRightNegInd);
    if FrontRightAbsN>0
        FrontRightSumAbs=sum(abs(QuartMat(FrontRightInd,4)));
        FrontRightMax=max(QuartMat(FrontRightInd,4));
        FrontRightMin=min(QuartMat(FrontRightInd,4));
    else
        FrontRightSumAbs=0;
        FrontRightMax=0;
        FrontRightMin=0;
    end
    if FrontRightPosN>0
        FrontRightSumPos=sum(abs(QuartMat(FrontRightPosInd,4)));
    else
        FrontRightSumPos=0;
    end
    if FrontRightNegN>0
        FrontRightSumNeg=sum(abs(QuartMat(FrontRightNegInd,4)));
    else
        FrontRightSumNeg=0;
    end
    
    BackRightInd=find(QuartMat(:,5)==2);
    BackRightPosInd=find(QuartMat(:,5)==2 & QuartMat(:,4)>0);
    BackRightNegInd=find(QuartMat(:,5)==2 & QuartMat(:,4)<0);
    BackRightAbsN=length(BackRightInd);
    BackRightPosN=length(BackRightPosInd);
    BackRightNegN=length(BackRightNegInd);
    if BackRightAbsN>0
        BackRightSumAbs=sum(abs(QuartMat(BackRightInd,4)));
        BackRightMax=max(QuartMat(BackRightInd,4));
        BackRightMin=min(QuartMat(BackRightInd,4));
    else
        BackRightSumAbs=0;
        BackRightMax=0;
        BackRightMin=0;
    end
    if BackRightPosN>0
        BackRightSumPos=sum(abs(QuartMat(BackRightPosInd,4)));
    else
        BackRightSumPos=0;
    end
    if BackRightNegN>0
        BackRightSumNeg=sum(abs(QuartMat(BackRightNegInd,4)));
    else
        BackRightSumNeg=0;
    end
    
    BackLeftInd=find(QuartMat(:,5)==3);
    BackLeftPosInd=find(QuartMat(:,5)==3 & QuartMat(:,4)>0);
    BackLeftNegInd=find(QuartMat(:,5)==3 & QuartMat(:,4)<0);
    BackLeftAbsN=length(BackLeftInd);
    BackLeftPosN=length(BackLeftPosInd);
    BackLeftNegN=length(BackLeftNegInd);
    if BackLeftAbsN>0
        BackLeftSumAbs=sum(abs(QuartMat(BackLeftInd,4)));
        BackLeftMax=max(QuartMat(BackLeftInd,4));
        BackLeftMin=min(QuartMat(BackLeftInd,4));
    else
        BackLeftSumAbs=0;
        BackLeftMax=0;
        BackLeftMin=0;
    end
    if BackLeftPosN>0
        BackLeftSumPos=sum(abs(QuartMat(BackLeftPosInd,4)));
    else
        BackLeftSumPos=0;
    end
    if BackLeftNegN>0
        BackLeftSumNeg=sum(abs(QuartMat(BackLeftNegInd,4)));
    else
        BackLeftSumNeg=0;
    end
    
    FrontLeftInd=find(QuartMat(:,5)==4);
    FrontLeftPosInd=find(QuartMat(:,5)==4 & QuartMat(:,4)>0);
    FrontLeftNegInd=find(QuartMat(:,5)==4 & QuartMat(:,4)<0);
    FrontLeftAbsN=length(FrontLeftInd);
    FrontLeftPosN=length(FrontLeftPosInd);
    FrontLeftNegN=length(FrontLeftNegInd);
    if FrontLeftAbsN>0
        FrontLeftSumAbs=sum(abs(QuartMat(FrontLeftInd,4)));
        FrontLeftMax=max(QuartMat(FrontLeftInd,4));
        FrontLeftMin=min(QuartMat(FrontLeftInd,4));
    else
        FrontLeftSumAbs=0;
        FrontLeftMax=0;
        FrontLeftMin=0;
    end
    if FrontLeftPosN>0
        FrontLeftSumPos=sum(abs(QuartMat(FrontLeftPosInd,4)));
    else
        FrontLeftSumPos=0;
    end
    if FrontLeftNegN>0
        FrontLeftSumNeg=sum(abs(QuartMat(FrontLeftNegInd,4)));
    else
        FrontLeftSumNeg=0;
    end
    
    FrontInd=find(QuartMat(:,6)==1);
    FrontPosInd=find(QuartMat(:,6)==1 & QuartMat(:,4)>0);
    FrontNegInd=find(QuartMat(:,6)==1 & QuartMat(:,4)<0);
    FrontAbsN=length(FrontInd);
    FrontPosN=length(FrontPosInd);
    FrontNegN=length(FrontNegInd);
    if FrontAbsN>0
        FrontSumAbs=sum(abs(QuartMat(FrontInd,4)));
        FrontMax=max(QuartMat(FrontInd,4));
        FrontMin=min(QuartMat(FrontInd,4));
    else
        FrontSumAbs=0;
        FrontMax=0;
        FrontMin=0;
    end
    if FrontPosN>0
        FrontSumPos=sum(abs(QuartMat(FrontPosInd,4)));
    else
        FrontSumPos=0;
    end
    if FrontNegN>0
        FrontSumNeg=sum(abs(QuartMat(FrontNegInd,4)));
    else
        FrontSumNeg=0;
    end
    
    BackInd=find(QuartMat(:,6)==2);
    BackPosInd=find(QuartMat(:,6)==2 & QuartMat(:,4)>0);
    BackNegInd=find(QuartMat(:,6)==2 & QuartMat(:,4)<0);
    BackAbsN=length(BackInd);
    BackPosN=length(BackPosInd);
    BackNegN=length(BackNegInd);
    if BackAbsN>0
        BackSumAbs=sum(abs(QuartMat(BackInd,4)));
        BackMax=max(QuartMat(BackInd,4));
        BackMin=min(QuartMat(BackInd,4));
    else
        BackSumAbs=0;
        BackMax=0;
        BackMin=0;
    end
    if BackPosN>0
        BackSumPos=sum(abs(QuartMat(BackPosInd,4)));
    else
        BackSumPos=0;
    end
    if BackNegN>0
        BackSumNeg=sum(abs(QuartMat(BackNegInd,4)));
    else
        BackSumNeg=0;
    end
    
    RightInd=find(QuartMat(:,7)==1);
    RightPosInd=find(QuartMat(:,7)==1 & QuartMat(:,4)>0);
    RightNegInd=find(QuartMat(:,7)==1 & QuartMat(:,4)<0);
    RightAbsN=length(RightInd);
    RightPosN=length(RightPosInd);
    RightNegN=length(RightNegInd);
    if RightAbsN>0
        RightSumAbs=sum(abs(QuartMat(RightInd,4)));
        RightMax=max(QuartMat(RightInd,4));
        RightMin=min(QuartMat(RightInd,4));
    else
        RightSumAbs=0;
        RightMax=0;
        RightMin=0;
    end
    if RightPosN>0
        RightSumPos=sum(abs(QuartMat(RightPosInd,4)));
    else
        RightSumPos=0;
    end
    if RightNegN>0
        RightSumNeg=sum(abs(QuartMat(RightNegInd,4)));
    else
        RightSumNeg=0;
    end
    
    LeftInd=find(QuartMat(:,7)==1);
    LeftPosInd=find(QuartMat(:,7)==2 & QuartMat(:,4)>0);
    LeftNegInd=find(QuartMat(:,7)==2 & QuartMat(:,4)<0);
    LeftAbsN=length(LeftInd);
    LeftPosN=length(LeftPosInd);
    LeftNegN=length(LeftNegInd);
    if LeftAbsN>0
        LeftSumAbs=sum(abs(QuartMat(LeftInd,4)));
        LeftMax=max(QuartMat(LeftInd,4));
        LeftMin=min(QuartMat(LeftInd,4));
    else
        LeftSumAbs=0;
        LeftMax=0;
        LeftMin=0;
    end
    if LeftPosN>0
        LeftSumPos=sum(abs(QuartMat(LeftPosInd,4)));
    else
        LeftSumPos=0;
    end
    if LeftNegN>0
        LeftSumNeg=sum(abs(QuartMat(LeftNegInd,4)));
    else
        LeftSumNeg=0;
    end
    
    NVec=[AllAbsN
        AllPosN 
        AllNegN
        AllSumAbs
        AllSumPos
        AllSumNeg
        AllMax
        AllMin
        FrontRightAbsN
        FrontRightPosN 
        FrontRightNegN
        FrontRightSumAbs
        FrontRightSumPos
        FrontRightSumNeg
        FrontRightMax
        FrontRightMin
        BackRightAbsN
        BackRightPosN 
        BackRightNegN
        BackRightSumAbs
        BackRightSumPos
        BackRightSumNeg
        BackRightMax
        BackRightMin
        BackLeftAbsN
        BackLeftPosN 
        BackLeftNegN
        BackLeftSumAbs
        BackLeftSumPos
        BackLeftSumNeg
        BackLeftMax
        BackLeftMin
        FrontLeftAbsN
        FrontLeftPosN 
        FrontLeftNegN
        FrontLeftSumAbs
        FrontLeftSumPos
        FrontLeftSumNeg
        FrontLeftMax
        FrontLeftMin
        FrontAbsN
        FrontPosN 
        FrontNegN
        FrontSumAbs
        FrontSumPos
        FrontSumNeg
        FrontMax
        FrontMin
        BackAbsN
        BackPosN 
        BackNegN
        BackSumAbs
        BackSumPos
        BackSumNeg
        BackMax
        BackMin
        RightAbsN
        RightPosN 
        RightNegN
        RightSumAbs
        RightSumPos
        RightSumNeg
        RightMax
        RightMin
        LeftAbsN
        LeftPosN 
        LeftNegN
        LeftSumAbs
        LeftSumPos
        LeftSumNeg
        LeftMax
        LeftMin
    ];
else
    NVec=zeros(1,72);
    AllAbsN=0;
end
fprintf(1,'All N: %g\n',AllAbsN);
fprintf(1,'All sum abs: %g\n',AllSumAbs);
fprintf(1,'All sum pos: %g\n',AllSumPos);
fprintf(1,'All sum neg: %g\n',AllSumNeg);
fprintf(1,'All max: %g\n',AllMax);
fprintf(1,'All min: %g\n',AllMin);
pause(1)
return;