%==================================================================
%
%	SaveEConfig.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%

%	Function definition

function SaveEConfig_pp(EPosSpher,ENames,FileMask,FilePath);

%=================================================================
if nargin<2; ENames=[]; end
	
[m,n]=size(EPosSpher);
if isempty(ENames);
	[ENames]=SetENames([],m);
end
	
if nargin<4
	if nargin<3;
		FileMask=[int2str(m),'.ecfg'];
	end
	[File,Path]=uiputfile(FileMask,'Save data to file:');
	if File==0; return; end
	FilePath=[Path,File];
end
SizeENames=size(ENames);
if prod(SizeENames)==m*6
	ENamesWrite=reshape(ENames,m*6,1);
else
	ENamesWrite=[];
end

fprintf('Save electrode configuration to disk in file:\n')	
fprintf(1,'%s',FilePath);
fprintf('\n');
if size(EPosSpher,2)==2
	Radius=0.09;
else
	Radius=EPosSpher(1,3);
end
fid=fopen(FilePath,'w','b');
count0=fwrite(fid,m,'int16'); %number of electrodes
count1=fwrite(fid,Radius,'float32');
count2=fwrite(fid,EPosSpher(:,1:2),'float32');%theta phi
if ~isempty(ENamesWrite)
	count3 = fwrite(fid,ENamesWrite,'uchar');
end
fclose(fid);
return;
