function WebpicAverage(sourcefilename,sourcefilepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      



%vars initialisieren
ratingscell=cell(1);
numberofpics=60;






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%datenbank einlesen und ergnzen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%datenfile einlesen;

dbfile=[sourcefilepath,sourcefilename];
fid=fopen(dbfile,'rt');
scenario=fscanf(fid,'%s',1);
discard=fscanf(fid,'%s',1);
anzahlvpcell=fscanf(fid,'%s',1);
anzahlvp=str2num(anzahlvpcell);
discard=fscanf(fid,'%s',1);
anzahlstimulicell=fscanf(fid,'%s',1);
anzahlstimuli=str2num(anzahlstimulicell);



dbalter=cell(1,anzahlvp);
dbgeschlecht=cell(1,anzahlvp);
dbdatum=cell(1,anzahlvp);
dbID=cell(1,anzahlvp);
dbhaendigkeit=cell(1,anzahlvp);
dbschulabschluss=cell(1,anzahlvp);

stimulus_aro=zeros(anzahlstimuli,anzahlvp);				
stimulus_val=zeros(anzahlstimuli,anzahlvp);					
stimulus_arotime=zeros(anzahlstimuli,anzahlvp);					
stimulus_valtime=zeros(anzahlstimuli,anzahlvp);	
stimulus_tottime=zeros(anzahlstimuli,anzahlvp);
stimulus_totalklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklickstd=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklickstd=zeros(anzahlstimuli,anzahlvp);	

    
%alter
    
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbalter{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
    
%geschlecht
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbgeschlecht{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end

%hndigkeit
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
    dbhaendigkeit{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end

%schulabschluss
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
    dbschulabschluss{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end

%datum
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
     dbdatum{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
     
%ID
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbID{1,e}=fscanf(fid,'%s',1); 
end
if isempty(e)
    e=0;
end



picreihenfolgecell=cell(1);
    
%stimuliparameter
for d=1:anzahlstimuli
    
    %arorating
    
    picnametemp=fscanf(fid,'%s',1);
    picreihenfolgecell{d}=picnametemp(9:findstr(picnametemp,'_aro')-1);
    
    for e=1:anzahlvp
        stimulus_aro(d,e)=str2num(fscanf(fid,'%s',1));
    end
	if isempty(e)
        e=0;
	end
    
    %valrating
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_val(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
    %arotime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_arotime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
    %valtime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valtime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
    %tottime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_tottime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
    %totalklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_totalklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end 
    if isempty(e)
    e=0;
    end
    
    %aroklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_aroklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
    %valklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
    %aroklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_aroklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
     
    %valklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    
end   				
        				
fclose(fid); 


%reihenfolge angleichen
%'picname' ist aus mail
%'picreihenfolgecell' ist aus db





%Avgfile schreiben...
%------------------------------------------------------------------------
%------------------------------------------------------------------------
            
[avgfilename,avgfilepath]=uiputfile('*.s_avg','Stimulus-Avgfile benennen (cancel fr berspringen):');
if ~isequal(avgfilename,0) & ~isequal(avgfilepath,0)
    if isempty(findstr(avgfilename,'.s_avg'))
                avgfilename=[avgfilename,'.s_avg'];
    end
	%Z-Werte
	% stimulus_aro=zeros(anzahlstimuli,anzahlvp);				
	% stimulus_val=zeros(anzahlstimuli,anzahlvp);					
	% stimulus_arotime=zeros(anzahlstimuli,anzahlvp);					
	% stimulus_valtime=zeros(anzahlstimuli,anzahlvp);	
	% stimulus_tottime=zeros(anzahlstimuli,anzahlvp);
	% stimulus_totalklicks=zeros(anzahlstimuli,anzahlvp);					
	% stimulus_aroklicks=zeros(anzahlstimuli,anzahlvp);					
	% stimulus_valklicks=zeros(anzahlstimuli,anzahlvp);					
	% stimulus_aroklickstd=zeros(anzahlstimuli,anzahlvp);					
	% stimulus_valklickstd=zeros(anzahlstimuli,anzahlvp);	
	z_stimulus_aro=zscore(stimulus_aro);				
	z_stimulus_val=zscore(stimulus_val);					
	z_stimulus_arotime=zscore(stimulus_arotime);					
	z_stimulus_valtime=zscore(stimulus_valtime);	
	z_stimulus_tottime=zscore(stimulus_tottime);
	z_stimulus_totalklicks=zscore(stimulus_totalklicks);					
	z_stimulus_aroklicks=zscore(stimulus_aroklicks);					
	z_stimulus_valklicks=zscore(stimulus_valklicks);					
	z_stimulus_aroklickstd=zscore(stimulus_aroklickstd);					
	z_stimulus_valklickstd=zscore(stimulus_valklickstd);	
    
	avgfile=[avgfilepath,avgfilename];
	fid = fopen(avgfile,'wt');
	if fid~=-1
        
		fprintf(fid,['filename\t']);
       
		for d=1:anzahlvp
                fprintf(fid,['VP',num2str(d),'_','stimulus_aro','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_val','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_arotime','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_valtime','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_tottime','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_totalklicks','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_aroklicks','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_valklicks','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_aroklickstd','\t']);
                fprintf(fid,['VP',num2str(d),'_','stimulus_valklickstd','\t']);
        end
        fprintf(fid,['AVG_','stimulus_aro','\t']);
        fprintf(fid,['AVG_','stimulus_val','\t']);
        fprintf(fid,['AVG_','stimulus_arotime','\t']);
        fprintf(fid,['AVG_','stimulus_valtime','\t']);
        fprintf(fid,['AVG_','stimulus_tottime','\t']);
        fprintf(fid,['AVG(Z)_','stimulus_arotime','\t']);
        fprintf(fid,['AVG(Z)_','stimulus_valtime','\t']);
        fprintf(fid,['AVG(Z)_','stimulus_tottime','\t']);
        fprintf(fid,['AVG_','stimulus_totalklicks','\t']);
        fprintf(fid,['AVG_','stimulus_aroklicks','\t']);
        fprintf(fid,['AVG_','stimulus_valklicks','\t']);
        fprintf(fid,['AVG_','stimulus_aroklickstd','\t']);
        fprintf(fid,['AVG_','stimulus_valklickstd\n']);

		for d=1:anzahlstimuli 
            fprintf(fid,picreihenfolgecell{d}); 
            for e=1:anzahlvp
                fprintf(fid,['\t',num2str(stimulus_aro(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_val(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_arotime(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_valtime(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_tottime(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_totalklicks(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_aroklicks(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_valklicks(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_aroklickstd(d,e))]);
                fprintf(fid,['\t',num2str(stimulus_valklickstd(d,e))]);
            end
            fprintf(fid,['\t',num2str(mean(stimulus_aro(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_val(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_arotime(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_valtime(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_tottime(d,:)))]);
            fprintf(fid,['\t',num2str(mean(z_stimulus_arotime(d,:)))]);
            fprintf(fid,['\t',num2str(mean(z_stimulus_valtime(d,:)))]);
            fprintf(fid,['\t',num2str(mean(z_stimulus_tottime(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_totalklicks(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_aroklicks(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_valklicks(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_aroklickstd(d,:)))]);
            fprintf(fid,['\t',num2str(mean(stimulus_valklickstd(d,:))),'\n']);
		end
        fclose(fid);    
    else
        errordlg('Invalid fid!','Achtung:');
        return
    end
end

return