%==================================================================
%
%	WriteFastWordSce.m
%
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	
%	Function definition

function [PicFilePath,SaveFilePath]=WriteFastWordsSce(SaveFilePath)
	
%=================================================================
if nargin<1;SaveFilePath=[]; end;
	
if isempty(SaveFilePath)
	[SaveFile,SavePath]=uiputfile('*.sce','Please choose a .sce file name:');
	SaveFilePath=[SavePath,SaveFile]
end

NBase=5
NWords=32;
RandBaseVec1=RandPerm(NBase)
RandBaseVec2=RandPerm(NBase)
RandVec1a=RandPerm(NWords)
RandVec2a=RandPerm(NWords)
RandVec1b=RandPerm(NWords)
RandVec2b=RandPerm(NWords)

fid=fopen(SaveFilePath,'w');

fprintf(fid,'screen_width = 640;\n');
fprintf(fid,'screen_height = 480;\n');
fprintf(fid,'screen_bit_depth = 16;\n');
fprintf(fid,'default_background_color = 0,0,0;\n');
fprintf(fid,'no_logfile = false;\n');
fprintf(fid,'active_buttons = 1;\n');
fprintf(fid,'button_codes = 1;\n');
fprintf(fid,'\n');
fprintf(fid,'begin;\n');
fprintf(fid,'picture{bitmap { filename = "fixation.bmp"; };x=0;y=0;} fix;\n');
fprintf(fid,'\n');
fprintf(fid,'trial {\n');
fprintf(fid,'trial_type=first_response;\n');    
fprintf(fid,'trial_duration=forever;\n');   
fprintf(fid,'picture fix;\n');     
fprintf(fid,'code="fixation";\n');
fprintf(fid,'duration=next_picture;\n');
fprintf(fid,'}show_fix;\n');
fprintf(fid,'\n');
fprintf(fid,'box {color = 0,0,0;width = 10;height = 10;} nixbox;\n');
fprintf(fid,'picture{ box nixbox; x= 0;  y = 0;} default;\n');
fprintf(fid,'trial {picture default;} wait;\n');  
fprintf(fid,'\n');


fprintf(fid,'bitmap { filename = "000.BMP"; } a000;\n');
fprintf(fid,'bitmap { filename = "001.BMP"; } a001;\n');
fprintf(fid,'bitmap { filename = "002.BMP"; } a002;\n');
fprintf(fid,'bitmap { filename = "003.BMP"; } a003;\n');
fprintf(fid,'bitmap { filename = "004.BMP"; } a004;\n');
fprintf(fid,'bitmap { filename = "005.BMP"; } a005;\n');
fprintf(fid,'bitmap { filename = "006.BMP"; } a006;\n');
fprintf(fid,'bitmap { filename = "007.BMP"; } a007;\n');
fprintf(fid,'bitmap { filename = "008.BMP"; } a008;\n');
fprintf(fid,'bitmap { filename = "009.BMP"; } a009;\n');

for i=1:NBase
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	j=NBase+i;
	if j<10
		jStr=['00',int2str(j)];
	elseif j>9 & j<100
		jStr=['0',int2str(j)];
	end
	fprintf(fid,['bitmap { filename = "FunkBase',iStr,'.BMP"; } aFunkBase',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "PseuBase',iStr,'.BMP"; } aPseuBase',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "InhaBase',iStr,'.BMP"; } aInhaBase',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "PseuBase',jStr,'.BMP"; } aPseuBase',jStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

for i=1:NWords
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	j=NWords+i;
	if j<10
		jStr=['00',int2str(j)];
	elseif j>9 & j<100
		jStr=['0',int2str(j)];
	end
	fprintf(fid,['bitmap { filename = "Funk',iStr,'.BMP"; } aFunk',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "Pseu',iStr,'.BMP"; } aPseu',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "Inha',iStr,'.BMP"; } aInha',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "Pseu',jStr,'.BMP"; } aPseu',jStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

fprintf(fid,'picture {bitmap a000 ;x =0;y=0;} b000;\n');
fprintf(fid,'picture {bitmap a001 ;x =0;y=0;} b001;\n');
fprintf(fid,'picture {bitmap a002 ;x =0;y=0;} b002;\n');
fprintf(fid,'picture {bitmap a003 ;x =0;y=0;} b003;\n');
fprintf(fid,'picture {bitmap a004 ;x =0;y=0;} b004;\n');
fprintf(fid,'picture {bitmap a005 ;x =0;y=0;} b005;\n');
fprintf(fid,'picture {bitmap a006 ;x =0;y=0;} b006;\n');
fprintf(fid,'picture {bitmap a007 ;x =0;y=0;} b007;\n');
fprintf(fid,'picture {bitmap a008 ;x =0;y=0;} b008;\n');
fprintf(fid,'picture {bitmap a009 ;x =0;y=0;} b009;\n');

for i=1:NBase
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	j=NBase+i;
	if j<10
		jStr=['00',int2str(j)];
	elseif j>9 & j<100
		jStr=['0',int2str(j)];
	end
	fprintf(fid,['picture {bitmap aFunkBase',iStr,';x =0;y=0;} bFunkBase',iStr,';\n']);
	fprintf(fid,['picture {bitmap aPseuBase',iStr,';x =0;y=0;} bPseuBase',iStr,';\n']);
	fprintf(fid,['picture {bitmap aInhaBase',iStr,';x =0;y=0;} bInhaBase',iStr,';\n']);
	fprintf(fid,['picture {bitmap aPseuBase',jStr,';x =0;y=0;} bPseuBase',jStr,';\n']);
end
fprintf(fid,'\n\n\n\n');


for i=1:NWords
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	j=NWords+i;
	if j<10
		jStr=['00',int2str(j)];
	elseif j>9 & j<100
		jStr=['0',int2str(j)];
	end
	fprintf(fid,['picture {bitmap aFunk',iStr,';x =0;y=0;} bFunk',iStr,';\n']);
	fprintf(fid,['picture {bitmap aPseu',iStr,';x =0;y=0;} bPseu',iStr,';\n']);
	fprintf(fid,['picture {bitmap aInha',iStr,';x =0;y=0;} bInha',iStr,';\n']);
	fprintf(fid,['picture {bitmap aPseu',jStr,';x =0;y=0;} bPseu',jStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

fprintf(fid,'\n\n\n\n');
fprintf(fid,'trial show_fix;\n');
fprintf(fid,'\n\n\n\n');

fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b000" "b000";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b001" "b001";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b002" "b002";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b003" "b003";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b004" "b004";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b005" "b005";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b006" "b006";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b007" "b007";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b008" "b008";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b009" "b009";};\n');

for k=1:NBase
	i=RandBaseVec1(k);
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	j=NBase+i;
	if j<10
		jStr=['00',int2str(j)];
	elseif j>9 & j<100
		jStr=['0',int2str(j)];
	end
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bFunkBase',iStr,'" "bFunkBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseuBase',iStr,'" "bPseuBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bInhaBase',iStr,'" "bInhaBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseuBase',jStr,'" "bPseuBase',jStr,'";};\n']);
end
fprintf(fid,'\n\n\n\n');

for k=1:NWords
	ia=RandVec1a(k);
	if ia<10
		iaStr=['00',int2str(ia)];
	elseif ia>9 & ia<100
		iaStr=['0',int2str(ia)];
	end
	ja=NWords+ia;
	if ja<10
		jaStr=['00',int2str(ja)];
	elseif ja>9 & ja<100
		jaStr=['0',int2str(ja)];
	end
	ib=RandVec1b(k);
	if ib<10
		ibStr=['00',int2str(ib)];
	elseif ib>9 & ib<100
		ibStr=['0',int2str(ib)];
	end
	jb=NWords+ib;
	if jb<10
		jbStr=['00',int2str(jb)];
	elseif jb>9 & jb<100
		jbStr=['0',int2str(jb)];
	end
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bFunk',iaStr,'" "bFunk',iaStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseu',ibStr,'" "bPseu',ibStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bInha',iaStr,'" "bInha',iaStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseu',jbStr,'" "bPseu',jbStr,'";};\n']);
end
fprintf(fid,'\n\n\n\n');

fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b000" "b000";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b001" "b001";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b002" "b002";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b003" "b003";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b004" "b004";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b005" "b005";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b006" "b006";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b007" "b007";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b008" "b008";};\n');
fprintf(fid,'TEMPLATE "alterwords_count.tem" { Bild ISSN ;"b009" "b009";};\n');

for k=1:NBase
	i=RandBaseVec2(k);
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	j=NBase+i;
	if j<10
		jStr=['00',int2str(j)];
	elseif j>9 & j<100
		jStr=['0',int2str(j)];
	end
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bFunkBase',iStr,'" "bFunkBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseuBase',iStr,'" "bPseuBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bInhaBase',iStr,'" "bInhaBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseuBase',jStr,'" "bPseuBase',jStr,'";};\n']);
end
fprintf(fid,'\n\n\n\n');

for k=1:NWords
	ia=RandVec2a(k);
	if ia<10
		iaStr=['00',int2str(ia)];
	elseif ia>9 & ia<100
		iaStr=['0',int2str(ia)];
	end
	ja=NWords+ia;
	if ja<10
		jaStr=['00',int2str(ja)];
	elseif ja>9 & ja<100
		jaStr=['0',int2str(ja)];
	end
	ib=RandVec2b(k);
	if ib<10
		ibStr=['00',int2str(ib)];
	elseif ib>9 & ib<100
		ibStr=['0',int2str(ib)];
	end
	jb=NWords+ib;
	if jb<10
		jbStr=['00',int2str(jb)];
	elseif jb>9 & jb<100
		jbStr=['0',int2str(jb)];
	end
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bFunk',iaStr,'" "bFunk',iaStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseu',ibStr,'" "bPseu',ibStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bInha',iaStr,'" "bInha',iaStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseu',jbStr,'" "bPseu',jbStr,'";};\n']);
end
fprintf(fid,'\n\n\n\n');

fprintf(fid,'trial show_fix;\n');
fprintf(fid,'\n\n\n\n');

fclose(fid);
return;
