function editspmmat(filename,filepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

try
    
	if nargin<2;filepath=[];end
	if nargin<1;filename=[];end
	file = [filepath,filename];
	if isempty(file)
        [filename,filepath]=uigetfile('*.mat','Please select SPM.mat-file:');
        file = [filepath,filename];
	end
	load(file);
	
     prompt={'Enter contrast to delete:'};
	def={num2str(length(SPM.xCon))};
	dlgTitle=['SPM.mat file has ',num2str(length(SPM.xCon)),' contrasts:'];
	lineNo=1;
	AddOpts.Resize='on';
	AddOpts.WindowStyle='normal';
	AddOpts.Interpreter='tex';
	answer=inputdlg(prompt,dlgTitle,lineNo,def,AddOpts);
	if isempty(answer{1})
        return
	end
	target = str2num(answer{1});
	SPM.xCon(target)=[];
	h = msgbox(['Deleting contrast ',answer{1},'!']);
	pause(0.1);
	save(file,'SPM');
	close (h);
    
catch
    disp(lasterr);
    return
end
   







return