function exportanovadata
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global hPlot3dMenuFig 
targetfilepath = [];
thispath = which('exportanovadata.m');
exportutilpath = strrep(thispath,'exportanovadata.m','exportanovadatautil.mat');
if exist(exportutilpath)
    load(exportutilpath);
end


decsep = questdlg('Choose decimal separator:','Export data:','komma','dot','komma');
hPlot3dList=get(hPlot3dMenuFig,'Userdata');
if ~isempty(hPlot3dList) 
    anovadata = get(hPlot3dList(133),'userdata');
    factor = get(hPlot3dList(131),'userdata');
elseif ~isempty(findobj('tag','hanovadata'))
    anovadata = get(findobj('tag','hanovadata'),'userdata');
    factor = get(findobj('tag','hfactorp2d'),'userdata');
else
    uiwait(errordlg('Could not retrieve current anovadata!','Critical error:'));
end
uigettextfigure = findobj('tag','uigettextfigure');
subjects = factor{1,1};
zeitpunkte = factor{1,2};
channelgroups = factor{1,3};
nroffactors = size(factor,1)-2 - factor{2,2};
movies = 1;
for j=1:nroffactors
    movies = movies*factor{j+2,2};
end
spaltenzahl=zeitpunkte*channelgroups*movies; 
betweenfactors = factor {2,2};
if isempty(betweenfactors)
    betweenfactors = 0;
end      
if ~isempty(targetfilepath)
    filterspec = [targetfilepath,'*.txt'];
else
    filterspec = ['*.txt'];
end
[targetfilename,targetfilepath]=uiputfile(filterspec,'Please name the datafile:');
if isequal(targetfilename,0) | isequal(targetfilepath,0)
    return
end
if isempty(findstr(targetfilename,'.txt'))
    targetfilename=[targetfilename '.txt'];
end
save(exportutilpath,'targetfilepath');

targetfile = [targetfilepath targetfilename];
targetfilehandle=fopen(targetfile,'wt');
header='subject';
for n=1:betweenfactors
    header = [header,char(9),factor{2+ nroffactors + n,1}];
end
header = [header,';'];
for moviezaehler=1:movies
   for channelgroupzaehler=1:channelgroups
      for zeitpunktezaehler=1:zeitpunkte
         variablename=sprintf('\tm%ic%it%i;',moviezaehler,channelgroupzaehler,zeitpunktezaehler);
         header=strrep(header,';',variablename);
      end
   end
end
header=strrep(header,';','');
fprintf(targetfilehandle,'%c',header);
fprintf(targetfilehandle,'\n');
if strcmp(decsep,'dot')
	for zeilenzaehler=1:subjects
       fprintf(targetfilehandle,'%c',['vp',num2str(zeilenzaehler)]);
       fprintf(targetfilehandle,'\t');
       for n=1:betweenfactors
            fprintf(targetfilehandle,[num2str(factor{2,3}{n}(zeilenzaehler)),'\t']);
       end
       for spaltenzaehler=1:spaltenzahl
           fprintf(targetfilehandle,[num2str(anovadata(zeilenzaehler,spaltenzaehler)),'\t']);
       end
       fprintf(targetfilehandle,'\n');
	end
else
    for zeilenzaehler=1:subjects
       fprintf(targetfilehandle,'%c',['vp',num2str(zeilenzaehler)]);
       fprintf(targetfilehandle,'\t');
       for n=1:betweenfactors
            fprintf(targetfilehandle,[num2str(factor{2,3}{n}(zeilenzaehler)),'\t']);
       end
       for spaltenzaehler=1:spaltenzahl
           fprintf(targetfilehandle,[strrep(num2str(anovadata(zeilenzaehler,spaltenzaehler)),'.',','),'\t']);
       end
       fprintf(targetfilehandle,'\n');
	end
end
fclose (targetfilehandle);

return
