function out = getlineindent(line)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if isempty(line)
    out = [];
    return
end

pos = 1;
while ~isletterpp(line(pos)) & ~isnumstring(line(pos)) & ~isnbdelimiter(line(pos))
    pos = pos+1;
    if pos>length(line)
        pos = pos -1;
        break
    end
end
firstpart = line(1:pos);
indents = length(findstr(firstpart,char(10)));
indents2 = length(findstr(firstpart,char(9)));
indents3 = length(findstr(firstpart,char(32)));
out = [char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)];

return