function [audiomodsignal]=highcut(audiosignal,audiofs,audiobits,cutoff,faktor)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
peakindices=find(abs(audiosignal)>cutoff);
anzahlpeaks=length(peakindices);
modindices=zeros(length(audiosignal),1);
modindices(peakindices)=1;

for i=1:anzahlpeaks
    if and(peakindices(i)-200>0,peakindices(i)+200<length(audiosignal))
        modindices(peakindices(i)-200:peakindices(i)+200,1)=1;
    elseif and(peakindices(i)-200>0,peakindices(i)+200>length(audiosignal))
        modindices(peakindices(i)-200:length(audiosignal),1)=1;
    elseif and(peakindices(i)-200<0,peakindices(i)+200<length(audiosignal))
        modindices(1:peakindices(i)+200,1)=1;
    else
        modindices(1:length(audiosignal),1)=1;
    end           
end

audiomodsignal=audiosignal;
endindices=find(modindices>0);
minusindices=find(modindices==0);
audiomodsignal(endindices)=audiosignal(endindices)*faktor;
audiomodsignal(minusindices)=audiosignal(minusindices)*0.7;
return
