function levelwavmanage(filename,filepath,mode)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


extensionedit=findobj('tag','extensionedit');
faktorstring=get(extensionedit,'string');
faktor=str2num(faktorstring);

if mode==0
   modefehler
   return
faktor=1;






% directory mode   
elseif mode==11
	cd (filepath);
	filelist=dir(filepath);
   filelistsize=size(filelist);
      
	% Schleife fr Files
   for filezaehler=3:filelistsize(1)
      [audio.signal,audio.fs,audio.bits]=wavread(filelist(filezaehler).name);
       audio.modsignal=audio.signal(:,1);
      [audio.modsignal] = levelwav(audio.modsignal,audio.fs,audio.bits,faktor);
       audio.modsignal=[audio.modsignal audio.modsignal];
	  % modifiziertes Signal abspeichern
		targetfilename=strrep(filelist(filezaehler).name, '.wav',[num2str(faktor*100),'.wav']);
		wavwrite(audio.modsignal,audio.fs,audio.bits,targetfilename);
   end
   ok
   
% batchfile mode   
elseif mode==12
   filemat=batchfiletomat(filename,filepath);
   filematgroessevec=size(filemat);
   filematgroesse=filematgroessevec(2);
   for l=1:filematgroesse
      [audio.signal,audio.fs,audio.bits]=wavread(filemat{l});
      audio.modsignal=audio.signal(:,1);
      [audio.modsignal] = levelwav(audio.modsignal,audio.fs,audio.bits,faktor);
      audio.modsignal=[audio.modsignal audio.modsignal];
      targetfilename=strrep(filemat{l},'.wav','mod.wav');
	  wavwrite(audio.modsignal,audio.fs,audio.bits,targetfilename);
   end
   return
      
% single file mode   
elseif mode==2
   [audiosignal,audiofs,audiobits]=wavread(filename);
   audiomodsignal=audiosignal(:,1);
   
   [audiomodsignal] = levelwav(audiomodsignal,audiofs,audiobits,faktor);
   %stereo-sound
   audiomodsignal=[audiomodsignal audiomodsignal];
   sound(audiomodsignal,audiofs);
   
   
	% modifiziertes Signal abspeichern
	targetfilename=strrep(filename, '.wav','mod.wav');
	wavwrite(audiomodsignal,audiofs,audiobits,targetfilename);
	ok
  
end
levelwavfenster=findobj('tag','levelwavfenster');
close(figure(levelwavfenster));
return