function [peakamplitude,gesamtleistung]=peakmorph(filename,filepath,kritfilename,kritfilepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

cd(filepath);
[audio.signal,audio.fs,audio.bits]=wavread(filename);
cd(kritfilepath);
[audiokrit.signal,audiokrit.fs,audiokrit.bits]=wavread(kritfilename);



audio.monosignal=audio.signal(:,1);
audiokrit.monosignal=audiokrit.signal(:,1);

intervall=length(audio.monosignal)/500;
leistungsvec=zeros(500,1);
for i=1:500
    leistungsvec(i,1)=(sum(abs(audio.monosignal(floor((i-1)*intervall+1):floor(i*intervall)))))/intervall;
end

intervall=length(audiokrit.monosignal)/500;
leistungskritvec=zeros(500,1);
for i=1:500
    leistungskritvec(i,1)=(sum(abs(audiokrit.monosignal(floor((i-1)*intervall+1):floor(i*intervall)))))/intervall;
end

modulation=zeros(500,1);
for i=1:500
    modulation(i,1)=leistungskritvec(i,1)/leistungsvec(i,1);
end;

for i=1:500
audio.monosignal(floor((i-1)*intervall+1):floor(i*intervall))=audio.monosignal(floor((i-1)*intervall+1):floor(i*intervall))*modulation(i);
end;

targetfilename=strrep(filename, '.wav','_gp.wav');
wavwrite(audio.monosignal,audio.fs,audio.bits,targetfilename);


fftsizevec=size(audio.signal);
fftsize=fftsizevec(1);
audiokritmag=zeros(fftsize,1);


% FFT berechnen
audio.kritspektrum=fft(audiokrit.monosignal);

% Komplexe Zahlen in real und imag-Teil aufsplitten
audio.kritrealspektrum=real(audio.kritspektrum);
audio.kritimagspektrum=imag(audio.kritspektrum);

% Magnitude der Originalfrequenzenberechnen
for l=2:fftsize
    z1=(audio.kritrealspektrum(l))^2;
    z2=(audio.kritimagspektrum(l))^2;
    audiokritmag(l,1)=sqrt(z1+z2);
end


fftsizemodvec=size(audio.monosignal);
fftsizemod=fftsizevec(1);
audiomodmag=zeros(fftsize,1);

% FFT berechnen
audio.modspektrum=fft(audio.monosignal);

% Komplexe Zahlen in real und imag-Teil aufsplitten
audio.modrealspektrum=real(audio.modspektrum);
audio.modimagspektrum=imag(audio.modspektrum);

% Magnitude der Originalfrequenzenberechnen
for l=2:fftsize
    z1=(audio.modrealspektrum(l))^2;
    z2=(audio.modimagspektrum(l))^2;
    audiomodmag(l,1)=sqrt(z1+z2);
end


 figure(5)
   subplot(2,1,1)
   plot(audiokritmag)
   subplot(2,1,2)
   plot(audiomodmag)

sound(audio.monosignal,audio.fs);


return