function [vertexmat,patchmat]=readASE(filepath,filename,displaystatus);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
patchzaehler=1;
punktezaehler=1;
global vertexmat patchmat
if nargin<1
    [ASEfilename,ASEfilepath]=uigetfile('*.ASE','Bitte whlen Sie den ASCI-Export von 3dmax aus:');
end
    
    ASEfile=[ASEfilepath,ASEfilename];
fid = fopen(ASEfile,'rt');


linestring = fgetl(fid);
while isempty(findstr('MESH_NUMVERTEX',linestring))
    linestring = fgetl(fid);
end
whitespace=findstr(linestring,' ');
numvertex=str2num(linestring(whitespace+1:end));
linestring = fgetl(fid);
whitespace=findstr(linestring,' ');
numpatch = str2num(linestring(whitespace+1:end));

%read vertices
%-----------------
while isempty(findstr('MESH_VERTEX_LIST',linestring))
    linestring = fgetl(fid);
end
linestring=fgetl(fid);
vertexzaehler=1;
vertexmat=[];
clc;
while isempty(findstr(linestring,'}'))
    linestring=strrep(linestring,'*MESH_VERTEX','');
    while ~isempty(findstr(linestring,'  '))
        linestring=strrep(linestring,'  ',' ');
    end
    data=str2num(linestring);
    vertexmat(vertexzaehler,:)=data(2:4);
    vertexzaehler=vertexzaehler+1;
    linestring=fgetl(fid);
    if mod(vertexzaehler,20)==0
        clc;
        fprintf([num2str(vertexzaehler),' of ',num2str(numvertex),' vertices read...','\n']);
        pause(0.001)
    end
end
clc;

fprintf('Done reading vertices!');
pause(1);


%read patches
%------------
while isempty(findstr('MESH_FACE_LIST',linestring))
    linestring = fgetl(fid);
end

linestring=fgetl(fid);
patchzaehler=1;
patchmat=[];
while isempty(findstr(linestring,'}'))
    linestring=strrep(linestring,'*MESH_FACE','');
    while ~isempty(findstr(linestring,'  '))
        linestring=strrep(linestring,'  ',' ');
    end
    a=findstr(linestring,'A:');
    b=findstr(linestring,'B:');
    c=findstr(linestring,'C:');
    ab=findstr(linestring,'AB:');
    patchmat(patchzaehler,1)=str2num(linestring(a+2:b-1));
    patchmat(patchzaehler,2)=str2num(linestring(b+2:c-1));
    patchmat(patchzaehler,3)=str2num(linestring(c+2:ab-1));
    patchzaehler=patchzaehler+1;
    linestring=fgetl(fid);
    if mod(patchzaehler,20)==0
        if mod(patchzaehler,20)==0
            clc;
            fprintf([num2str(patchzaehler),' of ',num2str(numpatch),' patches read...','\n']);
            pause(0.001)
        end
    end
end
patchmat=patchmat+1;
fprintf('Done reading patches!');
pause(0.001);
[savefilename,savefilepath]=uiputfile('*.mat','Please name the 3d-file:');
if isempty(findstr(savefilename,'.mat'))
    savefilename=[savefilename,'.mat'];
end
save([savefilepath,savefilename],'vertexmat','patchmat');

if nargout<1
	warning off
	t=patch('Vertices',vertexmat,'Faces',patchmat,'FaceVertexCData',hsv(1),'FaceColor','flat','EdgeColor','none');
	h = light('position',[0.1 0 0],'style','infinite','Color',[1 1 0]);
	view(45,20);
	% figure
	% patchmat2=patchmat-1,
	% t=patch('Vertices',vertexmat,'Faces',patchmat2,'FaceVertexCData',hsv(1),'FaceColor','flat','EdgeColor','none');
	% h = light('position',[0.1 0 0],'style','infinite','Color',[1 1 0]);
	% x=get(t,'XData');
	% y=get(t,'YData');
	% z=get(t,'ZData');
	
	% testx=x;
	% testy=y;
	% testz=z;
	% testx(size(testx,1)+1,:)=0;
	% testy(size(testy,1)+1,:)=0;
	% testz(size(testz,1)+1,:)=0;
	% testx(2:size(testx,1),:)=x;
	% testy(2:size(testy,1),:)=y;
	% testz(2:size(testz,1),:)=z;
end



fclose(fid);
return