function  [convec]=readlogfile(filename,filepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin <2;filepath = []; end
if nargin <1; [filename,filepath]=uigetfile('*.log','Bitte geben Sie ein log-file an:'); end
file = [filepath,filename];
cd(filepath);
fid = fopen(file,'r');
if fid == -1
  uiwait(errordlg(['fopen-fehler in ',file,'!'],'Fehler:'));
  return
end

line = fgetl(fid);

%Presentation-scenario
if ~isempty(findstr('cenario',line))
    
    %read header 
    %--------------------
    scenariotitle = line(12:end);
    
    %read date
    %-------------------
    datumline = fgetl(fid);
    whitespace = findstr(' ',datumline);
    datum = datumline(whitespace(3)+1:whitespace(4)-1);
    time = datumline(whitespace(4)+1:end);
    discard = fgetl(fid);
    
    %read column titles
    %---------------------
    columntitlecell=cell(1);
    columntitleline = fgetl(fid);
    whitespace = findstr(char(9),columntitleline);
    columntitlcecell{1}=columntitleline(1:whitespace(1)-1);
    for i=1:length(whitespace)-1
        columntitlcecell{i}=columntitleline(whitespace(i)+1:whitespace(i+1)-1);
    end
    columntitlcecell{length(whitespace)}=columntitleline(whitespace(end)+1:end);
   
    discard = fgetl(fid);
    
    %read data in trial{trialzaehler}{1,10}:Trialnumber EventType Code Time TTime Uncertainty Duration Uncertainty ReqTime ReqDur
    %-------------------------------------------------------------------------------------------
    trial= cell(1);
    trialzaehler = 1;
    zeilenstatus = 0;
    zeilenzaehler = 1;
    line = fgetl(fid);
    whitespace = findstr(char(9),line);
    trial{trialzaehler}=cell(1,10); 
    
    while isstr(line)
        
        %Trialnumber
        trial{trialzaehler}{1}=line(1:whitespace(1)-1);
        if trialzaehler > 1
            if strcmp(trial{trialzaehler}{1},trial{trialzaehler-1}{1})
                zeilenstatus =1;
            else
                zeilenstatus =0;
            end
        end
        if zeilenstatus == 1
            zeilenzaehler = zeilenzaehler +1;
            trialzaehler=trialzaehler-1;
            if zeilenzaehler == 2
                %Trialnumber
                trial{trialzaehler}{1}={trial{trialzaehler}{1};line(1:whitespace(1)-1)};
                %EventType
                trial{trialzaehler}{2}={trial{trialzaehler}{2};line(whitespace(1)+1:whitespace(2)-1)};
                %EventCode
                trial{trialzaehler}{3}={trial{trialzaehler}{3};line(whitespace(2)+1:whitespace(3)-1)};
                %Absolute Time
                trial{trialzaehler}{4}={trial{trialzaehler}{4};line(whitespace(3)+1:whitespace(4)-1)};
                %TrialTime
                trial{trialzaehler}{5}={trial{trialzaehler}{5};line(whitespace(4)+1:whitespace(5)-1)};
                %TTimeUncertainty
                trial{trialzaehler}{6}={trial{trialzaehler}{6};line(whitespace(5)+1:whitespace(6)-1)};
                %Duration
                trial{trialzaehler}{7}={trial{trialzaehler}{7};line(whitespace(6)+1:whitespace(7)-1)};
                %DurationUncertainty
                trial{trialzaehler}{8}={trial{trialzaehler}{8};line(whitespace(7)+1:whitespace(8)-1)};
                %ReqTime
                trial{trialzaehler}{9}={trial{trialzaehler}{9};line(whitespace(8)+1:whitespace(9)-1)};
                %RegDuration
                trial{trialzaehler}{10}={trial{trialzaehler}{10};line(whitespace(9)+1:end)};
            else
                trial{trialzaehler}{1}{zeilenzaehler}=line(1:whitespace(1)-1);
                %EventType
                trial{trialzaehler}{2}{zeilenzaehler}=line(whitespace(1)+1:whitespace(2)-1);
                %EventCode
                trial{trialzaehler}{3}{zeilenzaehler}=line(whitespace(2)+1:whitespace(3)-1);
                %Absolute Time
                trial{trialzaehler}{4}{zeilenzaehler}=line(whitespace(3)+1:whitespace(4)-1);
                %TrialTime
                trial{trialzaehler}{5}{zeilenzaehler}=line(whitespace(4)+1:whitespace(5)-1);
                %TTimeUncertainty
                trial{trialzaehler}{6}{zeilenzaehler}=line(whitespace(5)+1:whitespace(6)-1);
                %Duration
                trial{trialzaehler}{7}{zeilenzaehler}=line(whitespace(6)+1:whitespace(7)-1);
                %DurationUncertainty
                trial{trialzaehler}{8}{zeilenzaehler}=line(whitespace(7)+1:whitespace(8)-1);
                %ReqTime
                trial{trialzaehler}{9}{zeilenzaehler}=line(whitespace(8)+1:whitespace(9)-1);
                %RegDuration
                trial{trialzaehler}{10}{zeilenzaehler}=line(whitespace(9)+1:end); 
            end
        else
            zeilenzaehler=1;
            %EventType
            trial{trialzaehler}{2}=line(whitespace(1)+1:whitespace(2)-1);
            %EventCode
            trial{trialzaehler}{3}=line(whitespace(2)+1:whitespace(3)-1);
            %Absolute Time
            trial{trialzaehler}{4}=line(whitespace(3)+1:whitespace(4)-1);
            %TrialTime
            trial{trialzaehler}{5}=line(whitespace(4)+1:whitespace(5)-1);
            %TTimeUncertainty
            trial{trialzaehler}{6}=line(whitespace(5)+1:whitespace(6)-1);
            %Duration
            trial{trialzaehler}{7}=line(whitespace(6)+1:whitespace(7)-1);
            %DurationUncertainty
            trial{trialzaehler}{8}=line(whitespace(7)+1:whitespace(8)-1);
            %ReqTime
            trial{trialzaehler}{9}=line(whitespace(8)+1:whitespace(9)-1);
            %RegDuration
            trial{trialzaehler}{10}=line(whitespace(9)+1:end);
        end
        line = fgetl(fid);
        whitespace = findstr(char(9),line);
        trialzaehler = trialzaehler+1;
        zeilenstatus = 0;
    end
    fclose(fid);  
    
    
    %stimulireihenfolge
    %-------------------
    stimulinames=cell(1);
    stimulizaehler=1;
    convec = zeros(1,trialzaehler-1);
    for j=1:size(trial,2)
        if iscell(trial{j}{1})
            for k=1:size(trial{j}{1},1)
                stimulinames{stimulizaehler}=trial{j}{3}{k};
                if ~isempty(findstr(stimulinames{stimulizaehler},'probe'))
                    convec(stimulizaehler)= 1;
                end
                stimulizaehler=stimulizaehler+1;
            end
        else
            stimulinames{stimulizaehler}=trial{j}{3}; 
            if ~isempty(findstr(stimulinames{stimulizaehler},'probe'))
                    convec(stimulizaehler)= 1;
            end
            stimulizaehler=stimulizaehler+1;
        end
    end
    
    
    targetfile = strrep(file,'.log','.con');
    targetfid = fopen(targetfile,'wt');
    fprintf(targetfid,[num2str(trialzaehler-1),'\t',num2str(1),'\n']);
    for e=1:length(convec)
        fprintf(targetfid,[num2str(convec(e)),'\t']);
    end
    fprintf(targetfid,'\n');
    fclose(targetfid);
    ok
    
end

return

    
        
    