[filename,filepath]=uigetfile('*.log','log-file auswhlen');
[savefilename,savefilepath]=uiputfile('*.txt','ergebnisfile benennen:');
file=[filepath filename];
savefile=[savefilepath savefilename];
filehandle=fopen(file,'rt');
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
filestring=fscanf(filehandle,'%s');
soundnameindices=findstr('Picture',filestring);
valindices=findstr('val-rating:',filestring);
aroindices=findstr('aro-rating:',filestring);
anzahlsounds=size(soundnameindices);
soundnames=cell(anzahlsounds(2),1);
valratings=zeros(anzahlsounds(2),1);
aroratings=zeros(anzahlsounds(2),1);

for i=1:anzahlsounds(2)
   name=filestring(soundnameindices(i)+8:soundnameindices(i)+12);
   soundnames{i}=name;
   valrating=filestring(valindices(i)+11);
   valratings(i)=str2num(valrating);
   arorating=filestring(aroindices(i)+11);
   aroratings(i)=str2num(arorating);
end


savefilehandle=fopen(savefile,'wt');
fprintf(savefilehandle,'soundname\tvalence\tarousal\n');
fprintf(savefilehandle,'\n');

for i=1:anzahlsounds(2)
    fprintf(savefilehandle,[soundnames{i},'\t',num2str(valratings(i)),'\t',num2str(aroratings(i)),'\n']);
end

fclose(filehandle);
fclose(savefilehandle);



