function readwebratings(sourcefilepath,sourcefilename,filepath,filename)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin < 4
    file = filepath;
else
    file=[filepath,filename];
end

%vars initialisieren
ratingscell=cell(1);
numberofpics=60;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%mail einlesen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


fid=fopen(file,'rt');



%Datum
datumstring=fgetl(fid);
if ~isempty(findstr('From:',datumstring))
    datumstring = fgetl(fid),
end
datum=datumstring(7:length(datumstring));
whitespace=findstr(datum,' ');
datum(whitespace)='_';


discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);

%ID
IDstring = fgetl(fid);

ID=IDstring(5:size(IDstring,2));
correct=length(ID);
checkIDfile=fopen('F:\users\Peter\presentation\webrating\validIDs.txt','rt');
validIDmat=fscanf(checkIDfile,'%i');
fclose(checkIDfile);

if correct>9 | correct<8 | isempty(find(str2num(ID)==validIDmat))
    ButtonName=questdlg('Ungltige ID! Quit?', ...
                       'Achtung:', ...
                       'ja','nein','nein');
    switch ButtonName,
    case 'ja', 
        fclose all;
        return
    case 'nein',
    end
end


discard=fgetl(fid);




%geschlecht in geschlechtvar
geschlecht = fgetl(fid);
geschlecht_start=findstr(geschlecht,':');
geschlechtvar=geschlecht(geschlecht_start+2);

discard=fgetl(fid);

%haendigkeit
haendigkeit = fgetl(fid);
haendigkeit_start=findstr(haendigkeit,':');
haendigkeitvar=haendigkeit(haendigkeit_start+2);

discard=fgetl(fid);

%alter in altervar schreiben
alter=fgetl(fid);
alter_start=findstr(alter,':');
altervar=alter(alter_start+2:alter_start+3);
discard=fgetl(fid);

%bdi
bdi = fgetl(fid);
bdi_start=findstr(bdi,':');
bdivar=geschlecht(bdi_start:end);

discard=fgetl(fid);

%state
state = fgetl(fid);
state_start=findstr(state,':');
statevar=state(state_start+2:end);

discard=fgetl(fid);

%trait
trait = fgetl(fid);
trait_start=findstr(trait,':');
traitvar=trait(trait_start+2:end);

discard=fgetl(fid);


%verlauf in totalcall schreiben
verlaufsmatneu=fscanf(fid,'%s');
verlaufsmatneu(findstr(verlaufsmatneu,'-'))=[];
verlaufsmatneu(end+1)=',';

verlaufscell=cell(1);
kommata=findstr(verlaufsmatneu,',');
picindices=findstr(verlaufsmatneu,'stim');
nrofratedpics=0;  
for z=1:length(picindices)-1
    verlaufscell{z}=verlaufsmatneu(picindices(z):picindices(z+1)-1);
end

cellkommata=cell(1);
%anzahl der registrierten Stimuli feststellen (nrofratedpics)
verlaufscell{length(picindices)}=verlaufsmatneu(picindices(length(picindices)):length(verlaufsmatneu));
for v=1:length(verlaufscell)
    cellkommata{v}=findstr(verlaufscell{v},',');
    if length(cellkommata{v})>60
        break
    end
    nrofratedpics=nrofratedpics+1;
end

%totkommota um "verlaufsmat" einrcken
totkommata=findstr(verlaufsmatneu,',');
totkommata2=totkommata;
totkommata2(1,1)=15;
for r=1:length(totkommata)-1
    totkommata2(r+1)=totkommata(r);
end
totkommata2(length(totkommata)+1)=totkommata(length(totkommata));   

j=2;
for y=1:nrofratedpics
  for z=1:40
      totalcell{y,z}=verlaufsmatneu(totkommata2(j-1)+1:totkommata2(j)-1); 
      j=j+1;
  end
end  
discard=fgetl(fid);
discard=fgetl(fid);
fclose(fid);

picname=cell(1,nrofratedpics);
arorating=zeros(1,nrofratedpics);
valrating=zeros(1,nrofratedpics);
arotime=zeros(1,nrofratedpics);
valtime=zeros(1,nrofratedpics);
tottime=zeros(1,nrofratedpics);
totalklicks=zeros(1,nrofratedpics);
aroklicks=zeros(1,nrofratedpics);
valklicks=zeros(1,nrofratedpics);
aroklickstd=zeros(1,nrofratedpics);
valklickstd=zeros(1,nrofratedpics);



%totalcell auswerten
for y=1:nrofratedpics
  for z=1:40
      aroklickdata=[];
      valklickdata=[];
      if strmatch('http:',totalcell{y,z})
          picname{y}=totalcell{y,z}(findstr(totalcell{y,z},'ing/')+4:findstr(totalcell{y,z},'.jpg')-1);
      end
      if strmatch('aro_ok',totalcell{y,z})
          arorating(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z-2});
          arotime(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z+1});
          aroklicks(find(strcmp(picname,picname{y})))=round((z-6)/2);
          for g=1:aroklicks
              aroklickdata(g)=str2num(totalcell{y,6+(g-1)*2});
          end
          if length(aroklickdata)>1
              aroklickstd(find(strcmp(picname,picname{y})))=std(aroklickdata);
          else
              aroklickstd(find(strcmp(picname,picname{y})))=0;
          end
      end
      if strmatch('onset_val',totalcell{y,z})
          valstart=z;
      end
      if strmatch('val_ok',totalcell{y,z})
          valrating(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z-2});
          valtime(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z+1});
          tottime(find(strcmp(picname,picname{y})))=valtime(find(strcmp(picname,picname{y})))+arotime(find(strcmp(picname,picname{y})));
          valklicks(find(strcmp(picname,picname{y})))=round((z-valstart-3)/2);
          totalklicks(find(strcmp(picname,picname{y})))=valklicks(find(strcmp(picname,picname{y})))+aroklicks(find(strcmp(picname,picname{y})));
          for g=1:valklicks
              valklickdata(g)=str2num(totalcell{y,valstart+3+(g-1)*2});
          end
          if length(valklickdata)>1
              valklickstd(find(strcmp(picname,picname{y})))=std(valklickdata);
          else
              valklickstd(find(strcmp(picname,picname{y})))=0;
          end
      end    
  end
end 




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%datenbank einlesen und ergnzen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%datenfile einlesen;

dbfile=[sourcefilepath,sourcefilename];
fid=fopen(dbfile,'rt');
scenario=fscanf(fid,'%s',1);
discard=fscanf(fid,'%s',1);
anzahlvpcell=fscanf(fid,'%s',1);
anzahlvp=str2num(anzahlvpcell);
discard=fscanf(fid,'%s',1);
anzahlstimulicell=fscanf(fid,'%s',1);
anzahlstimuli=str2num(anzahlstimulicell);



dbalter=cell(1,anzahlvp);
dbgeschlecht=cell(1,anzahlvp);
dbdatum=cell(1,anzahlvp);
dbID=cell(1,anzahlvp);
dbhaendigkeit=cell(1,anzahlvp);

stimulus_aro=zeros(anzahlstimuli,anzahlvp);				
stimulus_val=zeros(anzahlstimuli,anzahlvp);					
stimulus_arotime=zeros(anzahlstimuli,anzahlvp);					
stimulus_valtime=zeros(anzahlstimuli,anzahlvp);	
stimulus_tottime=zeros(anzahlstimuli,anzahlvp);
stimulus_totalklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklickstd=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklickstd=zeros(anzahlstimuli,anzahlvp);	

    
%alter
    
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbalter{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbalter{1,e+1}=altervar;
    
%geschlecht
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbgeschlecht{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbgeschlecht{1,e+1}=geschlechtvar;

%hndigkeit
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
    dbhaendigkeit{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbhaendigkeit{1,e+1}=haendigkeitvar;


%datum
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
     dbdatum{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbdatum{1,e+1}=datum;
     
%ID
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbID{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbID{1,e+1}=ID;

picreihenfolgecell=cell(1);
    
%stimuliparameter
for d=1:anzahlstimuli
    if d>10
        'pause'
    end
    
    %arorating
    
    picnametemp=fscanf(fid,'%s',1);
    picreihenfolgecell{d}=picnametemp(9:findstr(picnametemp,'_aro')-1);
    
    for e=1:anzahlvp
        stimulus_aro(d,e)=str2num(fscanf(fid,'%s',1));
    end
	if isempty(e)
        e=0;
	end
    picreihenfolgecell{d}
    stimulus_aro(d,e+1)=arorating(find(strcmp(picreihenfolgecell{d},picname)));
    
    %valrating
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_val(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_val(d,e+1)=valrating(find(strcmp(picreihenfolgecell{d},picname)));
    
    %arotime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_arotime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_arotime(d,e+1)=arotime(find(strcmp(picreihenfolgecell{d},picname)));
    
    %valtime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valtime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_valtime(d,e+1)= valtime(find(strcmp(picreihenfolgecell{d},picname)));
    
    %tottime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_tottime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_tottime(d,e+1)= tottime(find(strcmp(picreihenfolgecell{d},picname)));
    
    %totalklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_totalklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end 
    if isempty(e)
    e=0;
    end
    stimulus_totalklicks(d,e+1)=totalklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    %aroklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_aroklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_aroklicks(d,e+1)=aroklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    %valklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_valklicks(d,e+1)=valklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    %aroklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_aroklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
     stimulus_aroklickstd(d,e+1)=aroklickstd(find(strcmp(picreihenfolgecell{d},picname)));
     
    %valklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_valklickstd(d,e+1)=valklickstd(find(strcmp(picreihenfolgecell{d},picname)));
    
end   				
        				
fclose(fid); 

%vpzahl erhhen!!!!!!
anzahlvp=anzahlvp+1;



%reihenfolge angleichen
%'picname' ist aus mail
%'picreihenfolgecell' ist aus db

for t=1:length(picreihenfolgecell)
    picnamereihenfolgevec(t)=find(strcmp(picreihenfolgecell{t},picname));
end


%datenbank wegschreiben
targetfile=[sourcefilepath,sourcefilename];
fid=fopen(targetfile,'wt');

%header
fprintf(fid,[scenario,'\tvps\t',num2str(anzahlvp),'\tstimuli\t',num2str(anzahlstimuli),'\n']);



%alter
fprintf(fid,'Alter');
for s=1:anzahlvp
    fprintf(fid,[' ',dbalter{s}]);
end
fprintf(fid,'\n');

%geschlecht
 fprintf(fid,'Geschlecht');
for s=1:anzahlvp
    fprintf(fid,[' ',dbgeschlecht{s}]);
end
fprintf(fid,'\n');


%hndigkeit
 fprintf(fid,'Hndigkeit');
for s=1:anzahlvp
    fprintf(fid,[' ',dbhaendigkeit{s}]);
end
fprintf(fid,'\n');

%datum
 fprintf(fid,'Datum');
for s=1:anzahlvp
    fprintf(fid,[' ',dbdatum{s}]);
end
fprintf(fid,'\n');

%ID
fprintf(fid,'ID');
for s=1:anzahlvp
    fprintf(fid,[' ',dbID{s}]);
end
fprintf(fid,'\n');

%stimuliparameter




for d=1:anzahlstimuli
    %arorating
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_aro']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aro(d,e))]);
    end
	if isempty(e)
	e=0;
	end
    fprintf(fid,'\n');
    
    %valrating
     fprintf(fid,['stimulus',picreihenfolgecell{d},'_val']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_val(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
    
    %arotime
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_arotime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_arotime(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
    
    %valtime
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_valtime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valtime(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
    
    %tottime
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_tottime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_tottime(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
   
    %totalklicks
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_totalklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_totalklicks(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
    
    %aroklicks
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_aroklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aroklicks(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
    
    %valklicks
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_valklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valklicks(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
    
    %aroklickstd
     fprintf(fid,['stimulus',picreihenfolgecell{d},'_aroklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aroklickstd(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
     
    %valklickstd
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_valklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valklickstd(d,e))]);
    end
if isempty(e)
    e=0;
end
    fprintf(fid,'\n');
end

fclose(fid);

return










