function [outmat]=shuffle(inmat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if iscell(inmat)
    a=linspace(1,length(inmat),length(inmat));
    a=shuffle(a);
    outmat=cell(1);
    for k=1:length(inmat)
        outmat{k}=inmat{a(k)};
    end
else
	if ~isempty(inmat)
		if (size(inmat,1) == 1 | size(inmat,2) == 1)
            rand('state',sum(100*clock));
			randomvec=randperm(length(inmat));
            %pause
			inmat(randomvec)=inmat;
            %pause
            outmat=inmat;
            %pause
		else
            rand('state',sum(100*clock));
            nrofelements = prod(size(inmat));
            order = randperm(nrofelements);
            outmat = reshape(inmat(order),size(inmat));
		end
	else
        outmat=[];
	end
end

return