function splithalfcon(filename,filepath,parts,anzahlat);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3
    parts=2;
if nargin<2
    filepath=[]; end;
end

if ~isempty(filepath)
    file=[filepath,filename];
else file=filename;
end
[convec,supfile,suppath,supfilepath,sizedata] =readascii(file);
ats=cell(anzahlat,1);
convec=convec';
for j=1:anzahlat
ats{j,1}=(find(convec==j));


for k=1:parts
convec(1,ats{j,1}(floor(1+(k-1)*(length(ats{j,1})/parts)):floor(k*(length(ats{j,1})/parts))))=str2num([num2str(j),num2str(k)]);
end;
end;

confilehandle=fopen(file,'rt');
if ~isempty(findstr(file,'.CON'))
    savefile=strrep(file,'.CON','.CON_sh');
else
    if ~isempty(findstr(file,'.con'))
        savefile = strrep(file,'.con','.con_sh');
    else 
        uiwait(errordlg('Couldnt create modified con-file due to naming conflict!'));
        return
    end
end
convec=convec';
savefilehandle=fopen(savefile,'wt');
fprintf(savefilehandle,[fgetl(confilehandle),'\n']);
line=fgets(confilehandle);
fprintf(savefilehandle,[num2str(convec'),'\n']);

while 1
    line=fgets(confilehandle);
    if ~isstr(line)
        break
    end
    fprintf(savefilehandle,char(line));
end

fclose(confilehandle);
delete(file);
fclose(savefilehandle);
savefilehandle=fopen(savefile,'rt');
helpvar=fscanf(savefilehandle,'%c');

if ~isempty(findstr(savefile,'.CON_sh'))
    savefile2=strrep(file,'.CON_sh','.CON');
else
    if ~isempty(findstr(savefile,'.con_sh'))
        savefile2 = strrep(file,'.con_sh','.con');
    else 
        uiwait(errordlg('Couldnt create modified con-file due to naming conflict!'));
        return
    end
end

savefilehandle2=fopen(savefile2,'wt');

fprintf(savefilehandle2,helpvar);
fclose(savefilehandle);
fclose(savefilehandle2);
delete(savefile);