function spmdirectory(filename,filepath,mode)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

olddir = pwd;

if nargin < 3;  mode = []; end
if nargin < 2;  filepath = pwd;end
if nargin < 1; filename = [];end




prompt={'Enter the number of subjects:','Enter the number of subfolders per subject:','Enter the name of the root directory:'};
def={'24','3','conditia_sound_spm'};
dlgTitle='Input parameters for directory structure:';
lineNo=1;
answer=inputdlg(prompt,dlgTitle,lineNo,def);
nrofsubjects = str2num(answer{1})
nrofsubs = str2num(answer{2})
rootdirtitle = answer{3}

cd(filepath);
if exist([filepath rootdirtitle])~=7
    status = mkdir(filepath,rootdirtitle)
    cd([filepath,rootdirtitle]);
else
    cd([filepath,filesep,rootdirtitle]);
end

for r=1:nrofsubjects
    if r<10
        if exist([filepath rootdirtitle filesep ['0',num2str(r)]])~=7
            mkdir([filepath,rootdirtitle],['0',num2str(r)]);
            subjectroot = [filepath,rootdirtitle,filesep,['0',num2str(r)]];
            cd([filepath,rootdirtitle,filesep,['0',num2str(r)]]);
        else
            subjectroot = [filepath,rootdirtitle,filesep,['0',num2str(r)]];
            cd([filepath,rootdirtitle,filesep,['0',num2str(r)]]);
        end
    else
        if exist(([filepath rootdirtitle filesep num2str(r)]))~=7
            mkdir([filepath,rootdirtitle], num2str(r));
            subjectroot = [filepath,rootdirtitle,filesep,num2str(r)];
            cd([filepath,rootdirtitle,filesep,num2str(r)]);
        else
            subjectroot = [filepath,rootdirtitle,filesep,num2str(r)];
            cd([filepath,rootdirtitle,filesep,num2str(r)]);
        end
    end
    
    
    for s=1:nrofsubs
        if s<10
            if exist(([filepath rootdirtitle filesep ['0',num2str(r)] filesep ['0',num2str(s)]]))~=7
                mkdir(subjectroot,['0',num2str(s)]);
            end
        else
            if exist(([filepath rootdirtitle filesep ['0',num2str(r)] filesep num2str(s)]))~=7
                mkdir(subjectroot, num2str(s));
            end
        end
    end
end

cd(olddir);
fclose all;
ok

return
