function vieweconfig(EConfigFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

%vieweconfig('C:\users\peter\pplib\Plot2d3d\Plot2dUtil\SensorCfg\129.ecfg');
if nargin < 1
    clear all;
%     close all;
end

global ENames besastatus plot2dstatus convertstatus
ENames=cell(1);
convertstatus ='no';

if nargin < 1
	[filename,filepath]=uigetfile('*.*','Please choose the sensor configuration file:');
	EConfigFilePath=[filepath,filename];
end


%besa
%-----------
if ~isempty(findstr(EConfigFilePath,'.elp')) | ~isempty(findstr(EConfigFilePath,'.ela')) | ~isempty(findstr(EConfigFilePath,'.elv')) | ~isempty(findstr(EConfigFilePath,'.ELP')) | ~isempty(findstr(EConfigFilePath,'.ELA')) | ~isempty(findstr(EConfigFilePath,'.ELV')) 
	besastatus=1;
    plot2dstatus = 0;
    fid = fopen(EConfigFilePath,'rt');
    SpherRadiustmp=1;
    theta = [];
	phi = [];
	line = fgetl(fid);
	linezaehler=1;
	warning off
    electrodenzaehler=1;
	while line~=-1
        poszaehler=1;
		warning on
		%tabs
		%-------
		if ~isempty(findstr(line,char(9)))
            tabs=findstr(char(9),line);
            firstelement=line(1:tabs(1)-1);
            if ~strcmp(firstelement,'EEG') & ~strcmp(firstelement,'poly')
                phi(linezaehler,1)=str2num(firstelement);
                secondelement=line(tabs(1):tabs(2)-1);
                theta(linezaehler,1)=str2num(secondelement);
            else
                firstelement=line(tabs(1):tabs(2)-1);
                phi(linezaehler,1)=str2num(firstelement);
                secondelement=line(tabs(2):tabs(3)-1);
                theta(linezaehler,1)=str2num(secondelement);
            end  
            line=fgetl(fid);
            linezaehler = linezaehler +1;
		%space
		%--------
		elseif ~isempty(findstr(line,char(32)))
            while ~isempty(findstr(line,'  '))
                line=strrep(line,'  ',' ');
            end
            whitespace=findstr(char(32),line);
            firstelement=line(1:whitespace(poszaehler)-1);
            if ~strcmp(firstelement,'EEG') & ~strcmp(firstelement,'poly') & length(str2num(firstelement))==1
                phi(linezaehler,1)=str2num(firstelement);
                secondelement=line(whitespace(1):whitespace(2)-1);
                theta(linezaehler,1)=str2num(secondelement);
            elseif length(str2num(firstelement))==0
                 ENames{electrodenzaehler}=firstelement;
                 electrodenzaehler=electrodenzaehler+1;
                while 1
                    if poszaehler<length(whitespace)
                        
                        firstelement=line(whitespace(poszaehler):whitespace(poszaehler+1)-1);
                        poszaehler=poszaehler+1;
                        if length(str2num(firstelement))==1
                            break
                        end
                    else
                        firstelement=line(whitespace(poszaehler):end);
                        poszaehler=poszaehler+1;
                        if length(str2num(firstelement))==1
                            break
                        else
                            uiwait(errordlg('Konnte Configurationsfile nicht einlesen!','Achtung:'));
                            return
                        end
                    end
                        
                end
                phi(linezaehler,1)=str2num(firstelement);
                if poszaehler<length(whitespace)
                    secondelement=line(whitespace(poszaehler):whitespace(poszaehler+1)-1);
                else
                    secondelement=line(whitespace(poszaehler):end);
                end
                theta(linezaehler,1)=str2num(secondelement);
            end  
            line=fgetl(fid);
            linezaehler = linezaehler +1;
		end
	end
    fclose(fid);
    if isempty(ENames)
        ENames=num2str(linspace(1,length(theta),length(theta))');
	end
    convertstatus = questdlg('Do you want to convert the sensor file to plot2d-format?','Convert-option:','yes','no','yes');
    

%plot2d
%------------
elseif ~isempty(findstr(EConfigFilePath,'.ecfg'))
    besastatus = 0;
    plot2dstatus = 1;
    [NChan,SpherRadius,EPosSpher,ENames,EConfigFile,EConfigPath,EConfigFilePath]=ReadEConfig(EConfigFilePath);
    theta=EPosSpher(:,1);
    phi=EPosSpher(:,2);
    SpherRadiustmp=1;
%sonst Abbruch
%-------------
else
    return
end


%grad-pi-umwandlung
%-----------------
if ~isempty(find(theta>2*pi))
    phi=phi./360*2*pi;
    theta=theta./360*2*pi;
end






%----------------------------------------------------------------------------------
%View sensor configuration
%---------------------------------------------------------------------------------- 
if besastatus == 1
    %positive Winkel
	%------------------
	phi(find(phi<0))=phi(find(phi<0))+2*pi;
	phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
	theta(find(theta<0))=theta(find(theta<0))+2*pi;
	theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;
	%drehen des sphere-coordinaten-systems;
	%-----------------------
	theta=theta;
	phi=pi/2-phi;
    %positive Winkel
	%------------------
	phi(find(phi<0))=phi(find(phi<0))+2*pi;
	phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
	theta(find(theta<0))=theta(find(theta<0))+2*pi;
	theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;
else
    %positive Winkel
	%------------------
	phi(find(phi<0))=phi(find(phi<0))+2*pi;
	phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
	theta(find(theta<0))=theta(find(theta<0))+2*pi;
	theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;
    %drehen des sphere-coordinaten-systems;
	%-----------------------
    theta=pi/2-theta;
	tmp=theta;
    theta=phi;
	phi=tmp;
    
    %positive Winkel
	%------------------
	phi(find(phi<0))=phi(find(phi<0))+2*pi;
	phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
	theta(find(theta<0))=theta(find(theta<0))+2*pi;
	theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;
end


figure('Name','Sensor-configuration:','Color',[1 1 1]);
radians=ones(1,length(theta))*SpherRadiustmp;
radians=radians';
[x,y,z]=sph2cart(theta,phi,radians);



%electrodes
%---------------
electrodes=plot3(x,y,z,'o','markerfacecolor',[0 0 0]);
if besastatus == 1
    
	x=get(electrodes,'XData');
	y=get(electrodes,'YData');
	z=get(electrodes,'ZData');
	electrodes=plot3(x,y,z,'o','markerfacecolor',[0 0 0]);
	
	%Rckwandeln in spherische Coordinates
	%-------------
	[theta,phi,radians]=cart2sph(x,y,z);
    
elseif plot2dstatus == 1
    
 
	x=get(electrodes,'XData');
	y=get(electrodes,'YData');
	z=get(electrodes,'ZData');
	electrodes=plot3(x,y,z,'o','markerfacecolor',[0 0 0]);
	
	%Rckwandeln in spherische Coordinates
	%-------------
	[theta,phi,radians]=cart2sph(x,y,z);
    
    
end



%positive Winkel
%------------------
phi(find(phi<0))=phi(find(phi<0))+2*pi;
phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
theta(find(theta<0))=theta(find(theta<0))+2*pi;
theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;


%Strahlen
%-----------
zerovec=zeros(size(x))';
hold on
for j=1:length(x)
    plot3([zerovec(j),x(j)],[zerovec(j),y(j)],[zerovec(j),z(j)],'color',[0 0 0]);
end

%Elektrodennamen
%------------------
if isempty(ENames)
    ENames =num2str( linspace(1,length(theta),length(theta))');
end
text(x+x*0.1,y+y*0.1,z+z*0.1,ENames);

%Bereich vergrern
xlim=get(gca,'xlim');
ylim=get(gca,'ylim');
zlim=get(gca,'zlim');
nullmat=[0 0];
xlim=[-1*abs(max(xlim))*1.5, abs(max(xlim))*1.5];
ylim=[-1*abs(max(ylim))*1.5, abs(max(ylim))*1.5];
zlim=[-1*abs(max(zlim))*1.5, abs(max(zlim))*1.5];
set(gca,'xlim',xlim);
set(gca,'ylim',ylim);
set(gca,'zlim',zlim);
%Achsen
xachse=plot3(xlim,nullmat,nullmat,'color',[0 0 0],'linewidth',2);
yachse=plot3(nullmat,ylim,nullmat,'color',[0 0 0],'linewidth',2);
zachse=plot3(nullmat,nullmat,zlim,'color',[0 0 0],'linewidth',2);
%Achsentitel
text(max(xlim)+max(xlim)*0.3,  0+max(ylim)*0.1,0+max(zlim)*0.1,'X(right)','color',[0 0 0],'fontsize',14);
text(0+max(xlim)*0.1,min(ylim)-max(ylim)*0.3,0+max(zlim)*0.1,'Y(back)','color',[0 0 0],'fontsize',14);
text(0+max(xlim)*0.1,0+max(ylim)*0.1,min(zlim)-max(zlim)*0.3,'Z(bottom)','color',[0 0 0],'fontsize',14);


%figure stylen
%---------------

set(gca,'Color','none');
figurecolor=get(gcf,'Color');
set(gca,'XTick',[]);
set(gca,'YTick',[]);
set(gca,'ZTick',[]);
set(gca,'XTickLabel','');
set(gca,'YTickLabel','');
set(gca,'ZTickLabel','');
set(gca,'XColor',figurecolor);
set(gca,'YColor',figurecolor);
set(gca,'ZColor',figurecolor);
set(gca,'Color',figurecolor);

%Pfeile der Achsen
%-----------------
%X-Achse
%---------
c1scaling=0.5;
c2scaling=0.5;
c3scaling=0.1;
%Pfeil
[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
c1=c1-ones(size(c1))*mean(mean(c1));
c1=c1*c1scaling;
c2=c2-ones(size(c2))*mean(mean(c2));
c2=c2*c2scaling;
c3=c3-ones(size(c3))*mean(mean(c3));
c3=c3*c3scaling;
cylinderhandle=surf(c1,c2,c3);
%Drehen in Achsenrichtung
rotate(cylinderhandle,[0 1 0],270);
c1=get(cylinderhandle,'XData');
c2=get(cylinderhandle,'YData');
c3=get(cylinderhandle,'ZData');
%Verschiebung in y-Richtung
c1=c1+ones(size(c1))*max(xlim);
cylinderhandle=surf(c1,c2,c3);
%Y-Achse
%---------
c1scaling=0.5;
c2scaling=0.5;
c3scaling=0.1;
%Pfeil
[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
c1=c1-ones(size(c1))*mean(mean(c1));
c1=c1*c1scaling;
c2=c2-ones(size(c2))*mean(mean(c2));
c2=c2*c2scaling;
c3=c3-ones(size(c3))*mean(mean(c3));
c3=c3*c3scaling;
cylinderhandle=surf(c1,c2,c3);
%Drehen in Achsenrichtung
rotate(cylinderhandle,[1 0 0],270);
c1=get(cylinderhandle,'XData');
c2=get(cylinderhandle,'YData');
c3=get(cylinderhandle,'ZData');
%Verschiebung in y-Richtung
c2=c2-ones(size(c2))*max(ylim);
cylinderhandle=surf(c1,c2,c3);
%Z-Achse
%----------
c1scaling=0.5;
c2scaling=0.5;
c3scaling=0.1;
%Pfeil
[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
c1=c1-ones(size(c1))*mean(mean(c1));
c1=c1*c1scaling;
c2=c2-ones(size(c2))*mean(mean(c2));
c2=c2*c2scaling;
c3=c3-ones(size(c3))*mean(mean(c3));
c3=c3*c3scaling;
cylinderhandle=surf(c1,c2,c3);
%Drehen in Achsenrichtung
rotate(cylinderhandle,[0 1 0],0);
c1=get(cylinderhandle,'XData');
c2=get(cylinderhandle,'YData');
c3=get(cylinderhandle,'ZData');
%Verschiebung in z-Richtung
c3=c3-ones(size(c3))*max(zlim);
cylinderhandle=surf(c1,c2,c3);



%Kugel einfgen
%----------------------
[a,b,c]=sphere(20);


xmean=mean(mean(x));
ymean=mean(mean(y));
zmean=mean(mean(z));

if abs(ymean)>0.2*(abs(max(y)-min(y))) | abs(zmean)>0.2*(abs(max(z)-min(z)))
	xdist=abs(x-xmean);
	ydist=abs(y-ymean);
	zdist=abs(z-zmean);
	dist=realsqrt(xdist.*xdist+ydist.*ydist+zdist.*zdist);
	mindist=min(min(dist));
	scaling=mindist*0.99;
    a=a*scaling;
	b=b*scaling;
	c=c*scaling;
    a=a+mean(mean(x));
	b=b+mean(mean(y));
	c=c+mean(mean(z));
else
    scaling = SpherRadiustmp*0.95;
    a=a*scaling;
	b=b*scaling;
	c=c*scaling;
end






axis equal;
colormap(gray);
surfl(a,b,c);
shading interp;


% set(gca,'CameraPosition',[0.0050    0.0050    2.6897]);
% set(gca,'CameraTarget',[0.0050    0.0050    0.0050]);
% set(gca,'CameraUpvector', [0.9998   -0.0175         0]);


%Ansicht von schrg oben
%----------------------------
totalfigure=get(gca,'children');
rotate(totalfigure,[0 0 1],90);






hold off


%Neues File schreiben
if strcmp(convertstatus,'yes')
	FileMask='*.ecfg';
	ENames=[];
	[FileName,FilePath]=uiputfile('*.ecfg','Bitte benennen sie das Elektroden-Config-file:');
    
    figure
    [x,y,z]=sph2cart(theta,phi,radians);
    electrodes=plot3(x,y,z,'o','markerfacecolor',[0 0 0]);
    
	tmp=phi;
    phi=theta;
	theta=tmp;
    theta=-1*theta+pi/2;
    
    
	EPosSpher=[theta' phi'];
    
    
    
	if isempty(findstr(FileName,'.ecfg'))
        FileName=[FileName,'.ecfg'];
	end
	FilePath=[FilePath,FileName];
	
	SaveEConfig_pp(EPosSpher,ENames,FileMask,FilePath);
end



return