function writenewdb(newfilename,newfilepath,filepath,filename);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin <4
    filename = [];
end
if nargin <3
    [filename,filepath]=uigetfile('*.txt','Bitte whlen sie eine Ratingdatei aus:');
end

if nargin < 2
    [newfilename,newfilepath]=uiputfile('*.wdb','Neue Datenbank benennen:')
    if isempty(findstr(newfilename,'.wdb'))
        newfilename=[newfilename,'.wdb'];
    end
end


file = [filepath,filename];



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%mail einlesen (nur picnames) %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


fid=fopen(file,'rt');
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);

%verlauf in totalcall schreiben
verlaufsmatneu=fscanf(fid,'%s');
verlaufsmatneu(findstr(verlaufsmatneu,'-'))=[];
verlaufsmatneu(end+1)=',';
verlaufscell=cell(1);
kommata=findstr(verlaufsmatneu,',');
picindices=findstr(verlaufsmatneu,'stim');
nrofratedpics=0;  
for z=1:length(picindices)-1
    verlaufscell{z}=verlaufsmatneu(picindices(z):picindices(z+1)-1);
end
cellkommata=cell(1);

%anzahl der registrierten Stimuli feststellen (nrofratedpics)
verlaufscell{length(picindices)}=verlaufsmatneu(picindices(length(picindices)):length(verlaufsmatneu));
for v=1:length(verlaufscell)
    cellkommata{v}=findstr(verlaufscell{v},',');
    if length(cellkommata{v})>60
        break
    end
    nrofratedpics=nrofratedpics+1;
end

%totkommota um "verlaufsmat" einrcken
totkommata=findstr(verlaufsmatneu,',');
totkommata2=totkommata;
totkommata2(1,1)=15;
for r=1:length(totkommata)-1
    totkommata2(r+1)=totkommata(r);
end
totkommata2(length(totkommata)+1)=totkommata(length(totkommata));   
j=2;
for y=1:nrofratedpics
  for z=1:40
      totalcell{y,z}=verlaufsmatneu(totkommata2(j-1)+1:totkommata2(j)-1); 
      j=j+1;
  end
end  
discard=fgetl(fid);
discard=fgetl(fid);
fclose(fid);
picname=cell(1,nrofratedpics);

%totalcell auswerten (picnames auslesen)
for y=1:nrofratedpics
  for z=1:40
      if strmatch('http:',totalcell{y,z})
          picname{y}=totalcell{y,z}(findstr(totalcell{y,z},'ing/')+4:findstr(totalcell{y,z},'.jpg')-1);
      end   
  end
end 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%vars initialisieren
ratingscell=cell(1);
numberofpics=65;
anzahlstimuli = 65;

%datenbank wegschreiben
newfile=[newfilepath,newfilename];
fid=fopen(newfile,'wt');

%keine Vps!
anzahlvp = 0;

%header
fprintf(fid,['webrating\tvps\t',num2str(0),'\tstimuli\t',num2str(65),'\n']);


dbalter=cell(1,anzahlvp);
dbgeschlecht=cell(1,anzahlvp);
dbdatum=cell(1,anzahlvp);
dbID=cell(1,anzahlvp);
dbhaendigkeit=cell(1,anzahlvp);
dbschulabschluss=cell(1,anzahlvp);
stimulus_aro=zeros(anzahlstimuli,anzahlvp);				
stimulus_val=zeros(anzahlstimuli,anzahlvp);					
stimulus_arotime=zeros(anzahlstimuli,anzahlvp);					
stimulus_valtime=zeros(anzahlstimuli,anzahlvp);	
stimulus_tottime=zeros(anzahlstimuli,anzahlvp);
stimulus_totalklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklickstd=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklickstd=zeros(anzahlstimuli,anzahlvp);	



%alter
fprintf(fid,'Alter');
for s=1:anzahlvp
    fprintf(fid,[' ',dbalter{s}]);
end
fprintf(fid,'\n');

%geschlecht
 fprintf(fid,'Geschlecht');
for s=1:anzahlvp
    fprintf(fid,[' ',dbgeschlecht{s}]);
end
fprintf(fid,'\n');

%hndigkeit
 fprintf(fid,'Hndigkeit');
for s=1:anzahlvp
    fprintf(fid,[' ',dbghaendigkeit{s}]);
end
fprintf(fid,'\n');

%schulabschluss
 fprintf(fid,'Schulabschluss');
for s=1:anzahlvp
    fprintf(fid,[' ',dbschulabschluss{s}]);
end
fprintf(fid,'\n');

%datum
 fprintf(fid,'Datum');
for s=1:anzahlvp
    fprintf(fid,[' ',dbdatum{s}]);
end
fprintf(fid,'\n');

%ID
fprintf(fid,'ID');
for s=1:anzahlvp
    fprintf(fid,[' ',dbID{s}]);
end
fprintf(fid,'\n');

%stimuliparameter
for d=1:anzahlstimuli
    %arorating
    fprintf(fid,['stimulus',picname{d},'_aro']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aro(d,e))]);
    end
    fprintf(fid,'\n');
    
    %valrating
     fprintf(fid,['stimulus',picname{d},'_val']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_val(d,e))]);
    end
    fprintf(fid,'\n');
    
    %arotime
    fprintf(fid,['stimulus',picname{d},'_arotime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aro(d,e))]);
    end
    fprintf(fid,'\n');
    
    %valtime
      fprintf(fid,['stimulus',picname{d},'_valtime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valtime(d,e))]);
    end
    fprintf(fid,'\n');
    
    %tottime
      fprintf(fid,['stimulus',picname{d},'_tottime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_tottime(d,e))]);
    end
    fprintf(fid,'\n');
   
    %totalklicks
    fprintf(fid,['stimulus',picname{d},'_totalklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_totalklicks(d,e))]);
    end
    fprintf(fid,'\n');
    
    %aroklicks
    fprintf(fid,['stimulus',picname{d},'_aroklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aroklicks(d,e))]);
    end
    fprintf(fid,'\n');
    
    %valklicks
      fprintf(fid,['stimulus',picname{d},'_valklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valklicks(d,e))]);
    end
    fprintf(fid,'\n');
    
    %aroklickstd
     fprintf(fid,['stimulus',picname{d},'_aroklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aroklickstd(d,e))]);
    end
    fprintf(fid,'\n');
     
    %valklickstd
    fprintf(fid,['stimulus',picname{d},'_valklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valklickstd(d,e))]);
    end
    fprintf(fid,'\n');
end

fclose(fid);

return