function AddFixCross


%   AddFixCross - adds a fixation cross to picture stimuli.
%   See also AddFixX.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

a=6;
b=6;
c=0
Path='Data:IAPS:AllPicsBitMap';
Path='Tim:Test'
Path='Data:IAPS:AllPicsBitMap'
PathOut='Tim:AllPicsBitMap';

D=dir(Path)
NFiles=size(D,1)
for FileInd=1:NFiles
	File=char(D(FileInd).name);
	ImMat=imread([Path,filesep,File],'bmp');
	SizeImMat=size(ImMat);
	XCenterPic=round(SizeImMat(1)./2);
	YCenterPic=round(SizeImMat(2)./2);
	ImMat(XCenterPic-a:XCenterPic+a,YCenterPic-b:YCenterPic+b,:)=zeros(2*a+1,2*b+1,3);
	for i=-c:c
		ImMat(XCenterPic-a:XCenterPic+a,YCenterPic+i,1)=255.*ones(2*a+1,1,1);
	end
	for i=-c:c
		ImMat(XCenterPic+i,YCenterPic-b:YCenterPic+b,1)=255.*ones(1,2*b+1,1);	
	end
	%image(ImMat)
	FilePathOut=[PathOut,filesep,File(1:length(File)-3),'rf.bmp']
	imwrite(ImMat,FilePathOut,'bmp');
	%pause
	for i=-c:c
		ImMat(XCenterPic-a:XCenterPic+a,YCenterPic+i,:)=255.*ones(2*a+1,1,3);
	end
	for i=-c:c
		ImMat(XCenterPic+i,YCenterPic-b:YCenterPic+b,:)=255.*ones(1,2*b+1,3);	
	end
	%image(ImMat)
	FilePathOut=[PathOut,filesep,File(1:length(File)-3),'wf.bmp']
	imwrite(ImMat,FilePathOut,'bmp');
	%pause
end
