function AddWavFiles(ExtSoundPath,ExtSoundFileInd,Factor)

%   AddWavFiles.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<3; Factor=[]; end
if nargin<2; ExtSoundFileInd=[]; end
if nargin<1; ExtSoundPath=[]; end

if isempty(ExtSoundPath); ExtSoundPath=['F:\User\Markus\IADS']; end
if isempty(ExtSoundFileInd); ExtSoundFileInd=15; end
if isempty(Factor);Factor=1.5; end

[ExtSoundFileMat,ExtSoundPath,NFiles]=GetFilesInDir(ExtSoundPath);
ExtSoundFilePath=[ExtSoundPath,filesep,ExtSoundFileMat(ExtSoundFileInd,:)];
[ExtSound,Fs,NBits]=wavread(ExtSoundFilePath);
ExtSound=ExtSound(1:end-1,:);
ExtSound=ExtSound./max(max(ExtSound));
NPoints=length(ExtSound);
Duration=NPoints./Fs;
Nyquist=floor(Fs./2);
FlaPoints=Fs./100;
LrPointVec=[4.5].*Fs;

LrPointVec=[1.1 2.4 3.6 4.8].*Fs;

FrequMat=[7 7.1;7.1 7.2;7.2 7.3]
NFrequ=size(FrequMat,1);
FrequMat=exp(FrequMat)
MinStartPoints=1.*Fs;
MinEndPoints=1.*Fs;
MinDistPoints=1.*Fs;
NLrSounds=3;
LRDur=0.5;
NLRPoints=LRDur.*Fs;
% MaxDistPoints=NPoints-MinStartPoints-MinEndPoints./((NLrSounds+1).*NLRPoints);
% RandVec=randperm(MaxDistPoints);
% RandVec=RandVec(find(RandVec>MinDistPoints));
LrPointVec=[1 3 4 2 3.5 4.5 1.5 3 4.5]

for FInd=1:NFrequ;
    LowFrequ=FrequMat(FInd,1);
    HighFrequ=FrequMat(FInd,2);;
    %[LR,Fs,WavFilePath]=GenNarrowBandWavFile(Fs,Duration,LowFrequ,HighFrequ,FlaPoints,IfftStatus,SoundStatus,PlotStatus,SaveStatus,WavPath)
    [LR,Fs,WavFilePath]=GenNarrowBandWavFile(Fs,LRDur,LowFrequ,HighFrequ,FlaPoints,0,0,0,0);
    NLRPoints=size(LR,1);
    LR=Factor.*LR;
    ActSound=ExtSound;
    for i=1:length(NLrSounds)
        LrPoint=LrPointVec((FInd-1).*NFrequ+i);
        ActSound(LrPoint:LrPoint+NLRPoints-1,:)=LR+ActSound(LrPoint:LrPoint+NLRPoints-1,:);
    end
    ActSound=ActSound./(1.1.*max(max(ActSound)));
    Sound(ActSound,Fs)
    PlotStatus=1
    if PlotStatus
        xPlot=linspace(0,Nyquist,NPoints./2);
        subplot(3,1,1)
        plot(ActSound(1:FlaPoints,1));
        subplot(3,1,2)
        plot(ActSound(:,1));
        FFTLR=fft(ActSound);
        PFFTLR=sqrt(real(FFTLR).*real(FFTLR)+imag(FFTLR).*imag(FFTLR))./(NPoints./2);
        PFFTLRPlot=PFFTLR(1:floor((length(PFFTLR)+1)./2));
        subplot(3,1,3)
        length(xPlot)
        length(PFFTLRPlot)
        plot(xPlot,PFFTLRPlot)
        axis([0 3000 0 1.1.*max(PFFTLRPlot)])
    end
    pause(Duration)
end