function [Data,Version,LHeader,ScaleBins,NChan,NPoints,NTrials,SampRate,AvgRefStatus,File,Path,FilePath,EegMegStatus,NChanExtra]=
	ReadAppData(FilePath,ActTrial,ActChan,ActPoint,PlotStatus,FilterSpec);
	
%  ReadAppData

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<6; FilterSpec='*.app*'; end;
if nargin<5;PlotStatus=0;end;
if nargin<4;ActPoint=[];end;
if nargin<3;ActChan=[];end;
if nargin<2;ActTrial=1;end;
if nargin<1;FilePath=[];end;

	
[File,Path,FilePath]=ReadFilePath(FilePath,FilterSpec,'Please choose an app file:')
if File==0; return; end
AppFid=fopen(FilePath,'r','b');
Version=fread(AppFid,1,'int16');
LHeader=fread(AppFid,1,'int16');
ScaleBins=fread(AppFid,1,'int16');
NChan=fread(AppFid,1,'int16');
NPoints=fread(AppFid,1,'int16');
NTrials=fread(AppFid,1,'int16');
SampRate=fread(AppFid,1,'int16');
AvgRefStatus=fread(AppFid,1,'int16');
if Version>1
	EegMegStatus=fread(AppFid,1,'int16');
	NChanExtra=fread(AppFid,1,'int16');
else
	EegMegStatus=1;
	NChanExtra=0;
end
NTotChan=NChan+NChanExtra;
if EegMegStatus==1		%EEG
	AppFormat='int16';
	NBit=2;
elseif EegMegStatus==2 	%MEG
	AppFormat='float32';
	NBit=4;
end
if ActTrial==0;  Data=[]; fclose(AppFid); return; end

if strcmp(ActTrial,'all')
	SeekStatus=fseek(AppFid,LHeader,-1);
	tell=ftell(AppFid);
	Data=zeros(NTrials,NTotChan,NPoints);
	for TrialInd=1:NTrials
		fprintf(1,'Read trial %g of %g ...\n',TrialInd,NTrials); 
		[Mat,Count]=fread(AppFid,[NPoints NTotChan],AppFormat);
		if Count~=NTotChan.*NPoints; 
			fprintf('Count~=NPoints.*NTotChan in ReadAppData'); 
			Data=[]; 
			fclose(AppFid);
			return; 
		end
		if EegMegStatus==1		%EEG
			Data(TrialInd,:,:)=Mat'./ScaleBins;
		elseif EegMegStatus==2 	%MEG
			Data(TrialInd,:,:)=Mat';
		end
	end
	fclose(AppFid);
	return;
end

if ActTrial>NTrials; 	fprintf('ActTrial>NTrials in ReadAppData'); return; end
if ActChan>NTotChan; 	fprintf('ActChan>NTotChan in ReadAppData'); return; end
if ActPoint>NPoints; 	fprintf('ActPoint>NPoints in ReadAppData'); return; end

SeekStatus=fseek(AppFid,LHeader+(ActTrial-1).*NTotChan.*NPoints.*NBit,-1);
if SeekStatus==-1; Message=ferror(AppFid); fprintf(Message); error('fseek2 error in ReadAppData'); end	
[Data,Count]=fread(AppFid,[NPoints NTotChan],AppFormat);
fclose(AppFid);

if Count~=NPoints.*(NChan+NChanExtra); 
	Data=[];
	fprintf('Count~=NPoints.*(NChan+NChanExtra) in ReadAppData'); 
	return; 
end
if ~isempty(ActChan) & isempty(ActPoint); 
	Data=Data(:,ActChan+NChanExtra); 
elseif isempty(ActChan) & ~isempty(ActPoint); 
	Data=Data(ActPoint,:); 
elseif ~isempty(ActChan) & ~isempty(ActPoint);
	Data=Data(ActPoint,ActChan); 
end
Data=Data';
if EegMegStatus==1		%EEG
	Data=Data./ScaleBins;
end
if PlotStatus; figure; plot(Data); end
return;
