function [OutFileMat]=Ascii2Scads(InFileMat)

%	Ascii2Scads

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

if nargin<1; InFileMat=[]; end
global Data DataMat
[DefFilePath] = SetDefPath(1,'*.asc*');
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose .asc files or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

if NFilesIn==0; return; end
%     prompt={'Enter the matrix size:'};
%    def={'9 148 356'};
%    dlgTitle='Matrix size';
%    lineNo=1;
%    answer=inputdlg(prompt,dlgTitle,lineNo,def);

NCells=9
NChan=148
NPoints=356
NTotData=NCells*NChan*NPoints;
DataMat=zeros(NCells,NChan,NPoints);
SampRate=508.6;
EegMegStatus=2;
NChanExtra=0;
IndOut=[1 5 6 4 2 3 7 8 9]
for FileInd=1:NFilesIn
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileInd);
	Nat=findstr(InFile,'.asc');
	if Nat(1)<length(InFile)-3
		OutFile=[InFile(1:Nat(1)-1),InFile(Nat+3:length(InFile)),'.at'];
	else
        OutFile=[InFile(1:Nat(1)-1),'.at'];
    end
    
    fid=fopen(InFilePath,'r','b');
    for ChanInd=1:NChan
        Data = fgetl(fid);
        Data=str2num(Data);
        Tmp=reshape(Data,NPoints,NCells);
        DataMat(:,ChanInd,:)=Tmp';
    end
    fclose(fid);

	NTrialAvgVec=ones(NChan,1);
	StdChanTimeMat=ones(NChan,NPoints);
	MedMedRawVec=ones(10,1);
	MedMedAvgVec=ones(10,1);
    
    for CellInd=1:NCells
        OutFileCell=[OutFile,int2str(IndOut(CellInd))];
        OutFilePathCell=[InPath,OutFileCell];
        AvgMat=squeeze(DataMat(CellInd,:,:));
	    SaveAvgFile(OutFilePathCell,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,[],MedMedAvgVec,EegMegStatus,NChanExtra);
    end
end
return;
