function [OutFileMat]=AvgApp(InFileMat,CalcBaseStatus,MinBase,MaxBase,FixNTrials)

%	AvgApp.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<5; FixNTrials=[]; end
if nargin<4; MaxBase=[]; end
if nargin<3; MinBase=[]; end
if nargin<2; CalcBaseStatus=[]; end
if nargin<1; InFileMat=[]; end

[CalcBaseStatus]=IfEmptyInputBo('Do you want to subtract a baseline ?',[],CalcBaseStatus,0,1);
if CalcBaseStatus & (isempty(MinBase) | isempty(MaxBase))
    fprintf('\n')
    [NPointsBaseStatus]=IfEmptyInputBo('Do you want to use','the whole interval as baseline ?',[],1,0);
    if NPointsBaseStatus; 
        MinBase=[]; MaxBase=[]; 
    else
        [MinBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MinBase,1,0);
        [MaxBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MaxBase,1,0);
    end
end
[DefFilePath]=SetDefPath(1,'*.app*');
OutFileMat=[];
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose .app files or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath)
SetDefPath(2,BatchPath);
for FileIndex=1:NFilesIn
    FileExt=['.at'];
    [AppFile,AppPath,AppFilePath]=GetFileNameOfMat(InFileMat,FileIndex)
    [AllAppMat,Version,LHeader,ScaleBins,NChan,NPoints,NTrials,SampRate,AvgRefStatus,File,Path,FilePath,EegMegStatus,NChanExtra]=ReadAppData(AppFilePath,'all');
    if CalcBaseStatus
        for i=1:NTrials
            if isempty(MinBase); MinBase=1; end
            if isempty(MaxBase); MaxBase=NPoints; end
            fprintf(1,'\n');
            fprintf(1,'AllAppMat: Subtract baseline interval of points %g - %g\n\n\n',MinBase,MaxBase);
            AllAppMat(i,:,:)=CalcBaseline(squeeze(AllAppMat(i,:,:)),MinBase,MaxBase,CalcBaseStatus);
        end
    else
        fprintf(1,'\n\n');
        fprintf(1,'AllAppMat: No baseline subtraction\n\n\n');
    end
    if CalcBaseStatus
        FileExt=[FileExt,'.b'];
    end
    fprintf(1,'\n');
    fprintf(1,'Average %g trials of file:\n',NTrials);
    disp(AppFilePath)
    fprintf(1,'\n');

    MeanAppMat=mean(AllAppMat,1);
    StdAppMat=std(AllAppMat,0,1);
    MedMedRawVec=zeros(NTrials,1);
    MedMedAvgVec=zeros(NTrials,1);
    if ~isempty(FixNTrials)
        NTrials=min([FixNTrials NTrials]);
    end
    for i=1:NTrials
        MedMedRawVec(i)=median(median(squeeze(AllAppMat(i,:,:))));
        MeanAppMat=mean(AllAppMat(1:i,:,:),1);
        MedMedAvgVec(i)=median(median(MeanAppMat(:,:)));
        if round(i./10)==i./10
			fprintf(1,'\n');
			fprintf(1,'%g of %g done ...\n',i,NTrials);
		else
			fprintf(1,'.');
		end
    end
    Tmp=findstr(AppFilePath,'.app');
    SaveFilePath=[AppFilePath(1:Tmp-1),FileExt];
    if length(AppFilePath)>Tmp+3
        SaveFilePath=[SaveFilePath,AppFilePath(Tmp+4:length(AppFilePath))];
    end
    SaveAvgFile(SaveFilePath,MeanAppMat,NTrials.*ones(NChan,1),StdAppMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
    if FileIndex==1
        OutFileMat=char(SaveFilePath);
    else
        OutFileMat=char(OutFileMat,SaveFilePath);
    end,
end, %for FileIndex=1:NFilesIn
return; 
