function [OutFileMat]=AvgAppPic

%	AvgAppPic.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

global MovNPicInd NTrialMat
NPic=length(MovNPicInd);
NTrialMat=zeros(NPic,5);

[LRSensorMat]=ReadData('BNC:Applications:MATLAB5:Plot2d3d:Plot2dUtil:Groups:LR-B-Groups129.txt',1,[],'ascii','ascii');
LRSensorMat=LRSensorMat';
LSensorVecInd=find(LRSensorMat(:,1)==1);
RSensorVecInd=find(LRSensorMat(:,1)==2);

LSensorVec=LRSensorMat(LSensorVecInd,2);
NLSensorVec=length(LSensorVec);
RSensorVec=LRSensorMat(RSensorVecInd,2);
NRSensorVec=length(RSensorVec);

SavePath=['Movie:PicAvg:'];
% for i=1:352
% 	PicInd=MovNPicInd((i-1).*2+2);
% 	if PicInd<10
% 		SaveFile=['000',int2str(PicInd)];
% 	elseif PicInd>9 & PicInd<100
% 		SaveFile=['00',int2str(PicInd)];
% 	elseif PicInd>99 & PicInd<1000
% 		SaveFile=['0',int2str(PicInd)];
% 	else
% 		SaveFile=int2str(PicInd);
% 	end
% 	SaveFile=[SaveFile,'.at.ar'];
% 	fprintf([SavePath,SaveFile]);fprintf('\n');
% end
% return
SubjIndStart=9;
SubjIndEnd=19;
NSubjects=SubjIndEnd-SubjIndStart+1;
MaxNTrials2Avg=NSubjects;

NChan=129;
NPoints=42;
AvgdMat=zeros(NChan,42);
StdMat=zeros(NChan,42);

for LoopInd=1:2
	for SpecTrial=1:NPic./2
		MovNPicIndInd=(SpecTrial-1).*2+LoopInd;
		PicInd=MovNPicInd(MovNPicIndInd);
		
		App3dMat=zeros(MaxNTrials2Avg,NChan,42);
		NTrials2Avg=0;
		for SubjInd=SubjIndStart:SubjIndEnd	
			if SubjInd<10
				SubjStr=['0',int2str(SubjInd)];
			else
				SubjStr=int2str(SubjInd);
			end
			AppPath=['Movie:',SubjStr,':',SubjStr,'N10:'];
			AppFile=[SubjStr,'N10A.E1.appg'];
			AppFilePath=[AppPath,AppFile];
	
			IndFilePath=AppFilePath(1:length(AppFilePath)-2);
			IndFilePath(length(IndFilePath)-1:length(IndFilePath))='ig';
			[IndVec,IndFile,IndPath,IndFilePath]=ReadData(IndFilePath,1,[],'ascii','ascii',[],[],'Index',[],0,0,[],'*.ig');
			SpecAppTrial=find(IndVec==SpecTrial);
			if ~isempty(SpecAppTrial)
				NTrials2Avg=NTrials2Avg+1;
				[AppMat,Version,LHeader,ScaleBins,NChan,NPointsTmp,NTrials,SampRate,chAvgRef]=ReadAppData(AppFilePath,SpecAppTrial);
				App3dMat(NTrials2Avg,:,:)=AppMat(:,(LoopInd-1).*42+1:LoopInd.*42);
				Start=(LoopInd-1).*42+1;
				fprintf('A; Subject: %g ; Picture: %g; Trials: %g; SpecTrial: %g; SpecAppTrial: %g; Start: %g',SubjInd,PicInd,NTrials2Avg,SpecTrial,SpecAppTrial,Start);
			else
				AppFile=[SubjStr,'N10B.E1.appg'];
				AppFilePath=[AppPath,AppFile];
				IndFilePath=AppFilePath(1:length(AppFilePath)-2);
				IndFilePath(length(IndFilePath)-1:length(IndFilePath))='ig';
				[IndVec,IndFile,IndPath,IndFilePath]=ReadData(IndFilePath,1,[],'ascii','ascii',[],[],'Index',[],0,0,[],'*.ig');
				SpecTrialTmp=SpecTrial+LoopInd-1;
				SpecAppTrial=find(IndVec==SpecTrialTmp);
				if ~isempty(SpecAppTrial)
					NTrials2Avg=NTrials2Avg+1;
					[AppMat,Version,LHeader,ScaleBins,NChan,NPointsTmp,NTrials,SampRate,chAvgRef]=ReadAppData(AppFilePath,SpecAppTrial);
					LoopIndTmp=abs(LoopInd-3);
					App3dMat(NTrials2Avg,:,:)=AppMat(:,(LoopIndTmp-1).*42+1:LoopIndTmp.*42);
					Start=(LoopIndTmp-1).*42+1;
					fprintf('B; Subject: %g ; Picture: %g; Trials: %g; SpecTrial: %g; SpecAppTrial: %g; Start: %g',SubjInd,PicInd,NTrials2Avg,SpecTrialTmp,SpecAppTrial,Start);
				end
			end
		end %SubjInd
		NTrialMat((SpecTrial-1).*2+LoopInd,1:2)=[PicInd NTrials2Avg];
		if NTrials2Avg>0
			SavePath=['Movie:PicAvg:'];
			if PicInd<10
				SaveFile=['000',int2str(PicInd)];
			elseif PicInd>9 & PicInd<100
				SaveFile=['00',int2str(PicInd)];
			elseif PicInd>99 & PicInd<1000
				SaveFile=['0',int2str(PicInd)];
			else
				SaveFile=int2str(PicInd);
			end
			SaveFile=[SaveFile,'.at.ar'];
			if NTrials2Avg>1
				AvgMat(:,:)=mean(App3dMat(1:NTrials2Avg,:,:));
				StdMat(:,:)=std(App3dMat(1:NTrials2Avg,:,:));
			else
				AvgMat(:,:)=App3dMat(1,:,:);
				StdMat(:,:)=App3dMat(1,:,:);
			end
			fprintf('\n\n')
			SaveAvgFile([SavePath,SaveFile],AvgMat,ones(NChan,1).*NTrials2Avg,StdMat,SampRate,ones(NChan,1).*NTrials2Avg,ones(NChan,1).*NTrials2Avg);
			AvgMat=CalcBaseline(AvgMat,14,22,1);
			NTrialMat(MovNPicIndInd,3)=sum(sqrt(sum(AvgMat(:,31:42).^2)))./(129.*12.*8);
			NTrialMat(MovNPicIndInd,4)=sum(sum(AvgMat(LSensorVec,31:42)))./(NLSensorVec.*12.*8);
			NTrialMat(MovNPicIndInd,5)=sum(sum(AvgMat(RSensorVec,31:42)))./(NRSensorVec.*12.*8);
		end
	end %SpecTrial
end %LoopInd
return;
