function [OutFilePath]=AvgScadsTStat(InFileMat,OutFilePath,StatStatus,chWeight,DefFileMask)

%	AvgScadsTStat
% 	This program is designed to calculate the independent and dependent t-
% 	statistics of AcgScads signal 

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


if nargin<5; DefFileMask='*at*'; end;
if nargin<4; chWeight=[]; end;
if nargin<3; StatStatus=1; end;
if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;
%==================================================================
[DefFilePath] = SetDefPath(1,DefFileMask);
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Avg files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

if NFiles==1; 
	fprintf(1,'Just one file in InFileMat \n');
	fprintf(1,'Running file: AvgScadsTStat');
	return;
elseif NFiles==0
	fprintf(1,'Sorry, no file in InFileMat !\n'); 
	fprintf(1,'Running file: AvgScadsTStat');
	return;
end

fprintf('\n\n');
Mean1=mean(FuncMat(:,:,SliceInd,IndVec1),4);
Mean2=mean(FuncMat(:,:,SliceInd,IndVec2),4);
Std1=std(FuncMat(:,:,SliceInd,IndVec1),0,4);
Std2=std(FuncMat(:,:,SliceInd,IndVec2),0,4);
Vari=sqrt((Std1.^2+Std2.^2)./Num);
ZeroVari=Vari==0;
Vari=Vari+ZeroVari;										%Set Vari=1 if Vari=0
if strcmp(StatStatus,'CalcIndT12') 
	MiCs(:,:,SliceInd)=(Mean1-Mean2)./Vari;
elseif strcmp(StatStatus,'CalcIndT21') 
	MiCs(:,:,SliceInd)=(Mean2-Mean1)./Vari;
end
MiCs(:,:,SliceInd)=MiCs(:,:,SliceInd)-MiCs(:,:,SliceInd).*ZeroVari;	%Set Vari=0 if Vari=0
