%	CreateExp2Besa.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


UnixStr=['lspdf -posted'];
[LsPdfStatus,LsPdfResult]=unix(UnixStr);
Tmp=findstr(LsPdfResult,'"');
if length(Tmp)>4
    LengthTmp=length(Tmp)
    LsPdfResult=LsPdfResult
end
HostName=[LsPdfResult(Tmp(3)+1:Tmp(4)-1)];
fprintf(1,['Data on host: ',HostName,'\n']);
HardDiskName=[LsPdfResult(Tmp(1)+1:Tmp(2)-1)];
fprintf(1,['Data on hard disk: ',HardDiskName,'\n']);

UnixStr=['get_pdfs -u -x'];
[GetPdfStatus,GetPdfResult]=unix(UnixStr);
TmpP=findstr(GetPdfResult,'-P');
TmpS=findstr(GetPdfResult,'-S');
Tmps=findstr(GetPdfResult,'-s');
Tmpr=findstr(GetPdfResult,'-r');
Tmpp=findstr(GetPdfResult,'-p');
NMsiFiles=length(TmpP);

for FileInd=1:NMsiFiles
    MsiPatient=[GetPdfResult(TmpP(FileInd)+3:TmpS(FileInd)-2)];
    MsiScan=[GetPdfResult(TmpS(FileInd)+3:Tmps(FileInd)-2)];
    MsiSession=[GetPdfResult(Tmps(FileInd)+3:Tmpr(FileInd)-2)];
    MsiSessionTmp=[MsiSession(2:9),'@',MsiSession(11:15)];
    MsiRun=[GetPdfResult(Tmpr(FileInd)+3:Tmpp(FileInd)-2)];
    if FileInd<NMsiFiles
        MsiFile=deblank([GetPdfResult(Tmpp(FileInd)+3:TmpP(FileInd+1)-2)]);
    else
        MsiFile=deblank([GetPdfResult(Tmpp(FileInd)+3:length(GetPdfResult)-2)]);
    end
    MsiPath=['/export/',HostName,filesep,HardDiskName,'/msi_data'];
    MsiPath=[MsiPath,filesep,MsiPatient,filesep,MsiScan,filesep,MsiSessionTmp,filesep,MsiRun];
    MsiFilePath=[MsiPath,filesep,MsiFile];
    
    %============create_set==================
    fprintf(1,'Create Set: file %g of %g:\n',FileInd,NMsiFiles)
    fprintf(1,'%s\n',MsiFilePath);
    UnixStr=['create_set -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' > ',MsiFilePath,'.set'];
    [UnixStatus,UnixResult]=unix(UnixStr);
    if UnixStatus~=0
        display(UnixResult)
    end
    %==============exp2besa===================
    fprintf(1,'Exp2Besa: file %g of %g\n',FileInd,NMsiFiles)
    fprintf(1,'%s\n',MsiFilePath);
    UnixStr=['exp2besa -n -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' ',MsiFilePath];
    [UnixStatus,UnixResult]=unix(UnixStr);
    if UnixStatus~=0
        display(UnixResult)
    end
end
return;