%	BatchPeterbase_nofil.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

clear all;

TRStatus=1;
[NNetFiles,RAWFileMat]=ReadFileNames([],'*.RAW');

[UseOverAllGainFileStatus]=IfEmptyInputBo('Do you want to use one special gain and one special zero file ?',[],[],1,1);

if UseOverAllGainFileStatus
	DefFilePath=SetDefPath(1,'*.Gain');
	[GainFile,GainPath,GainFilePath]=ReadFilePath([],DefFilePath,'Please choose the over all gain file:');
	SetDefPath(2,GainPath);
	DefFilePath=SetDefPath(1,'*.Zero');
	[ZeroFile,ZeroPath,ZeroFilePath]=ReadFilePath([],DefFilePath','Please choose the over all zero file:');
	if GainFile==0; GainFile=[]; GainPath=[]; GainFilePath=[]; end
	if ZeroFile==0; ZeroFile=[]; ZeroPath=[]; ZeroFilePath=[]; end
else
	GainFilePath=[];
	ZeroFilePath=[];
end

%===============FilterNetFile====================================

%Filter 50 Hz LowPass
% ch_LowPassFilt=1;
% ch_HighPassFilt=0;
% SampRate=[];
% if ch_LowPassFilt | ch_HighPassFilt
% 	for FileInd=1:NNetFiles
% 		[NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RAWFileMat,FileInd);
% 		[NoUse,NoUse,NoUse,NoUse, ...
% 		NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, ...
% 		SampRateTmp,NChan]= ReadRAWHeader(NetFilePath);
% 		if ~isempty(SampRate)
% 			 if SampRateTmp~=SampRate
% 				error('It is not possible to filter in batch mode because of different samp rates in different files !')
% 			end
% 		end
% 		SampRate=SampRateTmp;
% 	end
% end
% 
% HighDefFreqsMat=[SampRate 3 0];
% HighDefRipMat=[3 45];
% LowDefFreqsMat=[SampRate 40 50]; 
% LowDefRipMat=[3 45];
% ch_ChooseChannelInd=0;
% ChanStatusVec=ones(NChan,1);
% PlotStatus=0;
% ch_AddSubZeros=0;
% NZPoints=[];
% 
% [ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat] = ...
% GetHighLowFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
% ch_LowPassFilt,ch_HighPassFilt);

%=============================================================

%===============Transform data file format=======================
[TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20);

%DeleteFileMat(RAWFileMat);

%===============FilterNetFile====================================
% [FilterTAWFileMat]=FilterNetFile(TAWFileMat,ch_LowPassFilt,LowB,LowA,...
% ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat,...
% ch_ChooseChannelInd,ChanStatusVec,PlotStatus,ch_AddSubZeros,NZPoints,TRStatus);

%=============================================================
%DeleteFileMat(TAWFileMat);

% [EGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHistNew(NetFileMat,TRStatus,...
% PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
% NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,DMeanSampleStatus)
%[FilterEGISFileMat]=TransNetGeoHist(FilterTAWFileMat,TRStatus,83,84,1,GainFilePath,ZeroFilePath,0,[],[1 2 3])
[FilterEGISFileMat]=TransNetGeoHist(TAWFileMat,TRStatus,25,100,1,GainFilePath,ZeroFilePath,0,[],[1 2 3])

%[FilterEGISFileMat]=TransNetGeoHist(FilterTAWFileMat,TRStatus,83,84,1,GainFilePath,ZeroFilePath)


%===============CalcAutoEditMat ohne avg ref EEG und ohne flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);
[AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,[],0,[],1,[],[],1,8,0,0);

%======Suche nach schlechten Kanaelen ==================================
%FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus);
FindBadChan(AEMFilePathMat,3,1);

%======Suche nach schlechten trials ==================================
% [AWEFileMat]=FindBadChanTrial(FilePathMat,AWELimesFac,BatchStatus);
FindBadChanTrial(AEMFilePathMat,2.5,1);
 
%===============CalcAutoEditMat mit avg ref EEG und mit flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);

[AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,[],1,1,1,[],[],0,8,1,1);

