%	BatchSimon

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   


clear all;

NsFileMat=[];

global evtags offset
%=================================================================
PreTrig=250;
PostTrig=250;
BaseStart=1;
BaseEnd=250;
%==================================================================
[DefFilePath]=SetDefPath('r','*.cnt')

[NNsFiles,NsFileMat,NonUse,BatchFilePath]=ReadFileNames(NsFileMat,DefFilePath,'Choose .cnt file(s):')
if NNsFiles==0; return; end
SetDefPath('w',BatchFilePath);
FiltStatus=1;
if FiltStatus
    %====================Filter============================================
    MaxMemory=100;
    LineFrequ=50;
    HighFiltStatus=0;
    HighFrequ=2;
    HighN=6;
    LowFiltStatus=1;
    LowFrequ=40;
    LowN=6;
    StopFiltStatus=0;
    StopFrequ=[LineFrequ-1 LineFrequ+1];
    StopN=6;
    [FiltNsFileMat]=FiltNeuroscanFiles(NsFileMat,LowFiltStatus,LowFrequ,LowN, ...
        HighFiltStatus,HighFrequ,HighN,StopFiltStatus,StopFrequ,StopN)
else
   FiltNsFileMat=NsFileMat;
end
%=============Dataformat=================================================                       
[EgisFileMat,ConFileMat]=NeuroScan2EgisTonKon(FiltNsFileMat,PreTrig,PostTrig,0)

%==============Artefaktkorrektur===========================00
TimeStatusVec=ones(500,1);
TimeStatusVec(1,225)=0;
TimeStatusVec(375:end)=0;
[AEMFilePathMat]=CalcAutoEditMat(EgisFileMat,TimeStatusVec,0,[],1,BaseStart,BaseEnd,1,10,0,0);

%======Such nach schlechten Kanaelen ==================================
%FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus);
FindBadChan(AEMFilePathMat,3,1);

%======Such nach schlechten trials ==================================
% [AWEFileMat]=FindBadChanTrial(FilePathMat,AWELimesFac,BatchStatus);
FindBadChanTrial(AEMFilePathMat,2.5,1);

%===============CalcAutoEditMat mit avg ref EEG und mit flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);
[AEMFilePathMat]=CalcAutoEditMat(EgisFileMat,TimeStatusVec,1,1,1,BaseStart,BaseEnd,0,8,1,1);
