%	BatchSpeedAll400.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

clear all;

%==================================================================

TRStatus=-1;
DefFilePath=SetDefPath('r','*.TAW');
[NNetFiles,FilterTAWFileMat,NonUse,BatchFilePath]=ReadFileNames([],DefFilePath);
if NNetFiles==0; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath('w',BatchPath);

for i=1:NNetFiles
	[FilterTAWFile,FilterTAWPath,FilterTAWFilePath]=GetFileNameOfMat(FilterTAWFileMat,i);
	PreTrig=0;
	if ~isempty(findstr(FilterTAWFile,'0050.'))
		PostTrig=99;
	elseif ~isempty(findstr(FilterTAWFile,'0075.'))
		PostTrig=99;
	elseif ~isempty(findstr(FilterTAWFile,'0100.'))
		PostTrig=99;
	elseif ~isempty(findstr(FilterTAWFile,'0125.'))
		PostTrig=99;
	elseif ~isempty(findstr(FilterTAWFile,'0150.'))
		PostTrig=99;
	elseif ~isempty(findstr(FilterTAWFile,'0200.'))
		PostTrig=99;
	elseif ~isempty(findstr(FilterTAWFile,'0250.'))
		PostTrig=124;
	elseif ~isempty(findstr(FilterTAWFile,'0300.'))
		PostTrig=149;
	elseif ~isempty(findstr(FilterTAWFile,'0500.'))
		PostTrig=249;
	elseif ~isempty(findstr(FilterTAWFile,'1000.'))
		PostTrig=499;
	end
	FilterEGISFile=[FilterTAWFile(1:8),'400.E1']
	FilterEGISFilePath=[FilterTAWPath,FilterEGISFile]
	TransNetGeoHist(FilterTAWFilePath,TRStatus,PreTrig,PostTrig,1,[],[],[],[],[],[],[],[],[],[],[],FilterEGISFilePath)
	if i==1
		FilterEGISFileMat=char(FilterEGISFilePath);
	else
		FilterEGISFileMat=char(FilterEGISFileMat,FilterEGISFilePath);
	end
end


%===============CalcAutoEditMat ohne avg ref EEG und ohne flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);
[AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,[],0,[],1,[],[],1,8,0,0);

%======Suche nach schlechten Kanaelen ==================================
%FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus);
FindBadChan(AEMFilePathMat,3,1);

%======Suche nach schlechten trials ==================================
% [AWEFileMat]=FindBadChanTrial(FilePathMat,AWELimesFac,BatchStatus);
FindBadChanTrial(AEMFilePathMat,2.5,1);
 
%===============CalcAutoEditMat mit avg ref EEG und mit flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);

[AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,[],1,1,1,[],[],0,8,1,1);

