function[AEMFilePathMat]=CalcAutoEditMEGMat(MsiFileMat,TimeStatusVec,CalcBaseStatus,BaseStartPoint,BaseEndPoint);


%   CalcAutoEditMEGMat

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.     

if nargin<5; BaseEndPoint=[]; end
if nargin<4; BaseStartPoint=[]; end
if nargin<3; CalcBaseStatus=0; end
if nargin<2; TimeStatusVec=[]; end
if nargin<1; MsiFileMat=[]; end
String='Choose MSI session file(s):';
[DefPath]=SetDefPath(1,'*ses.msi');
[NFiles,MsiFileMat]=ReadFileNames(MsiFileMat,DefPath,String);
if NFiles==0; return; end

[AEMFilePathMat]=FileNameExt2Mat(MsiFileMat,'.AEM');

for FileIndex=1:NFiles
	
	[MsiFile,MsiPath,MsiFilePath]=GetFileNameOfMat(MsiFileMat,FileIndex);
	SetFilePath=PutFileExt2Mat(MsiFilePath,'.set');
	[SetFilePath,ParaVec,MEGSensorPosMat,EEGSensorPosMat,MEGSensorNameVec,EEGSensorNameVec,MEGSensorIndexVec,EEGSensorIndexVec]=ReadMsiSet(SetFilePath);

	NTotChan=ParaVec(1)
	NPoints=ParaVec(2)
	NTrials=ParaVec(3);
	NMegChan=ParaVec(4);
	NEegChan=ParaVec(5);
	SampRate=ParaVec(6);
	SampPeriod=ParaVec(7);
	BaseMs=ParaVec(8);
    Duration=ParaVec(9);
    NBit=ParaVec(10);
    NExternChan=ParaVec(11);
	NMEegChan=NMegChan+NEegChan;

	if isempty(TimeStatusVec)
		TimeStatusVec=ones(NPoints,1);
	end
	[TimeIndVec,NoTimeIndVec,TimeStatusVec,NInt,IntStartVec]=ChooseTimeIndTmp(1,[],[],TimeStatusVec,NPoints);		
	if isempty(TimeIndVec); error('TimeIndVec is empty in CalcAutoEditMEGMat !'); end
	NPointsCalc=length(TimeIndVec);
	for NIntIndex=1:NInt
		NoTransVec(NIntIndex)=find(TimeIndVec==IntStartVec(NIntIndex));
	end
	TransStatusVec=ones(size(TimeIndVec));
	if NInt>1
		TransStatusVec(NoTransVec)=zeros(length(NoTransVec),1);
	end
	
	%=======================================================	
	AbsMat=ones(NTrials,NMegChan);
	TraMat=ones(NTrials,NMegChan);
	StdMat=ones(NTrials,NMegChan);	
	
	fprintf('\n')
	clc;
	fprintf('Start reading data from file...\n\n');
	fprintf(MsiFilePath);
	fprintf('\n\n');
	MsiFid=fopen(MsiFilePath,'r');
	
	for TrialIndex=1:NTrials
		DataMat=fread(MsiFid,[NMEegChan,NPoints],'float');
		DataMat=DataMat(1:NMegChan,TimeIndVec);	
		%==========Subtract the baseline=================
		if CalcBaseStatus
			[DataMat]=CalcBaseline(DataMat,BaseStartPoint,BaseEndPoint);	
		end
		DataMat=DataMat';	%Da std, abs etc ueber Kanaele rechnen wuerden
		%==========Calculate the StdMat=================
		StdMat(TrialIndex,:)=std(DataMat);
		%==========Calculate the AbsMat=================
		AbsMat(TrialIndex,:)=max(abs(DataMat));	
		%==========Calculate the TraMat=================
		MaxAbsVec=zeros(1,NMegChan);
		AbsVecTmp=zeros(1,NMegChan);		
		for TimeIndex=2:NPointsCalc	
			if TransStatusVec(TimeIndex)	
				AbsVecTmp=abs(DataMat(TimeIndex,:)-DataMat(TimeIndex-1,:));
				HigherChan=find(AbsVecTmp>MaxAbsVec);
				MaxAbsVec(HigherChan)=AbsVecTmp(HigherChan);
			end
		end
		TraMat(TrialIndex,:)=MaxAbsVec;
		if TrialIndex==1 | round(TrialIndex./10)==TrialIndex./10
			fprintf('\n');
			fprintf('Trial %g of %g     ',TrialIndex,NTrials);
		else
			fprintf('.');
		end
	end %for TrialIndex
	fclose(MsiFid);
	%=============================Save EditMat to file================================================================
	[AEMFile,AEMPath,AEMFilePath]=GetFileNameOfMat(AEMFilePathMat,FileIndex);
	[NoUse,EndPos]=SaveData(AbsMat',AEMFilePath,1);
	[NoUse,EndPos]=SaveData(StdMat',AEMFilePath,1,[],'int16','float32',1,EndPos);
	[NoUse,EndPos]=SaveData(TraMat',AEMFilePath,1,[],'int16','float32',1,EndPos);
	SaveData(ones(size(AbsMat))',AEMFilePath,1,[],'int16','float32',1,EndPos);
	
end	%FileIndex
return;
