function[CsdFileMat]=CalcCsdAvgFile(AvgFileMat)

%	CalcCsdAvgFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

%==================================================================
if nargin<1; AvgFileMat=[]; end
%==================================================================
DefFilePath=SetDefPath('r','*.at*');
[NFiles,AvgFileMat,VersionString,BatchFilePath]=ReadFileNames(AvgFileMat,DefFilePath,'Choose Avg. file:');
if NFiles==0; return; end
DefFilePath=SetDefPath('w',BatchFilePath);
[AvgFile,AvgPath,AvgFilePath]=GetFileNameOfMat(AvgFileMat,1);
[AvgMat,DataFile,DataPath,DataFilePath,NTrialAvgVec,StdChanTimeMat,...
SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(AvgFilePath);
[NTotChan,NPoints]=size(AvgMat)
NChanCalc=NTotChan-NChanExtra;
CoeffPath='C:\Programme\Matlab6p5\Anwendungen\Plot2d3d\Plot3dCoeff40'
LegFilePath=which('Leg_1_0_5001');
[LegFile,LegPath]=SepFilePath(LegFilePath);
LegPath='C:\Programme\Matlab6p5\Anwendungen\Plot2d3d\Plot3dLegCoeff'
ECfgFile=[int2str(NChanCalc),'.ecfg'];
ECfgFilePath=which(ECfgFile);
fprintf('Start reading sensor configuration from file...\n\n');
disp(ECfgFilePath)
fprintf('\n\n');
[NChan,SpherRadius,EPosSpher,ENames,EConfigFile,EConfigPath,EConfigFilePath]=ReadEConfig(ECfgFilePath)
AllEPosCart = change_sphere_cart(EPosSpher,SpherRadius,1);

[InvCoeff]=ReadOrCalcCoeff(1,AllEPosCart,AllEPosCart,LegPath,CoeffPath,ECfgFile,32,15,0,5001);
[CsdCoeff]=ReadOrCalcCoeff(3,AllEPosCart,AllEPosCart,LegPath,CoeffPath,ECfgFile,32,15,0,5001);
GoodChanVec=find(NTrialAvgVec(1:NChanCalc)>0);
NGoodChan=length(GoodChanVec);
AllChanOnes=ones(1,NChanCalc);
InvCoeff=InvCoeff(GoodChanVec,GoodChanVec);
[LambdaApprox]=IfEmptyInputVal(['Please insert the wished Lambda value of Approximation:'],[],[],0.02,1);
Lambda=LambdaApprox.*InvCoeff(1,1);
InvCoeff=InvCoeff+Lambda.*eye(NChanCalc);
CsdMat=zeros(size(AvgMat));
for FileIndex=1:NFiles
	[AvgFile,AvgPath,AvgFilePath]=GetFileNameOfMat(AvgFileMat,FileIndex);
	[AvgMat,DataFile,DataPath,DataFilePath,NTrialAvgVec,StdChanTimeMat,...
    SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(AvgFilePath);
	CsdMat=AvgMat;
    TmpAvgMat=AvgMat(GoodChanVec,:);
    c0=mean(TmpAvgMat);
	TmpAvgMat=TmpAvgMat-(c0'*ones(1,NGoodChan))';
	DipStrength = InvCoeff(GoodChanVec,GoodChanVec) \ TmpAvgMat;
	TmpAvgMat=(DipStrength' * CsdCoeff(GoodChanVec,:))';
	CsdMat(1:NChanCalc,:)=TmpAvgMat+(c0'*AllChanOnes)';
    CsdFilePath=[AvgFilePath,'.',int2str(LambdaApprox.*1000),'.csd'];
	SaveAvgFile(CsdFilePath,CsdMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
    if FileIndex==1
       CsdFileMat=char(CsdFilePath);
    else
        CsdFileMat=char(CsdFileMat,CsdFilePath);
    end
end
return;


