function [ParaMat,FileMat]=CalcPicPara(FileMat,SaveFilePath,CalcAllSpatStatus,CalcHsvStatus)

%   CalcPicPara.m
%
%   Calculates a few physical image parameters of JPG files
%   given in the character matrix FileMat, (e.g. FileMat=['Path1,filesep,File1';'Path2,filesep,File2'; ...]
%   In case SaveFilePath is empty or not a function input argument the program calls ReadFileNames.m
%   Open image files one by one adding these files to the file list (press cancel if done) or open a batch file 
%   containing full file names (inclusive path) of existing files  (each filepath in a column) in a txt file
%
%   The program needs a SaveFilePath in order to save the calculated parameter
%   If SaveFilePath is empty or not a function input argument the user will be asked
%   to choose an output file name (default is PicParaAll.txt)
%
%   The program saves all parameter in this file and a short version of the most 
%   important ones in a SaveFilePath file with  extension ".s"
%   The files contain a label header with labeld devided by blanks; 
%   Use the "import with label" function to import these data into Stat programs like Jump, Statview etc.
%
%
%   The output matrix ParaMat is a n x m matrix with n=number of image files 
%   and m=20+4x40 (just rgb) or m=20+7x40 (if rgb and hsv)
%   Some rows of ParaMat are are for future use => set to zero
%
%   If CalcAllSpatStatus is 0, empty or not a function input argument the program calculates 
%   SVD and PFFT parameter for black and white only (if CalcAllSpatStatus=1 also red, green, blue, etc.)
%
%   if CalcHsvStatus is 0, empty or not a function input argument the program calculates 
%   parameter for red, green and blue only (not hue, saturation and value)
%   if CalcHsvStatus is 0 the program calls rgb2hsv.m (RGB2HSV Convert red-green-blue colors to hue-saturation-value)
%
%
%   The rows used are the following: 
%
%   Row 1:      q = total number of pixel in horzontal direction inclusive black border
%   Row 2:      p = total number of pixel in vertical direction inclusive black border
%   Row 3:      Width = number of pixel in horzontal direction exclusive black border
%   Row 4:      Height = number of pixel in vertical direction exclusive black border
%   Row 5:      Height2Width = Width / Height
%   Row 6:      Land2Port = -1 if landscape (Width>Height), 0 if quadaratic (Width=Height;)  1 if portrait (Width<Height)
%   Row 7:      Jpg100FileSize = original size of jpg file in bit without compression;       JPG is a type of image compression which is - in some way - based on physiological rules
%   Row 8:      Jpg900FileSize = size of jpg file in bit with 90% quality compression;     Therefore JPG file size is a reasonable parameter of image complexity.
%   Row 9-20   for future use
%
%   Row 21-60:     Parameter for image in black and white
%   Row 21-40:     inclusive black border
%   Row 41-60:     exclusive black border
%
%   Row 21 or 41:     Brightness  (Mean across all pixel)
%   Row 22 or 42:     Contrast    (Std across all pixel)
%   Row 23 or 43:     Jpg100FileSize
%   Row 24 or 44:     Jpg90FileSize
%   Row 25 or 45:     RelSvd1 = Percentage of image explained by first singular value (first eigenimage); svd  = Singular value decomposition; A parameter of image complexity
%   Row 26 or 46:     RelSvd5 = Percentage of image explained by the first five singular values (first five eigenimages); 
%   Row 27 or 47:     Svd25    = Number of singular values explaining 25% of the image
%   Row 28 or 48:     Svd50    = Number of singular values explaining 50% of the image
%   Row 29 or 49:     HorHalfCut  = Half cut frequency cutting the mean across all horizontal frequency distributions;  PFFT across each of the p or Height horizontal pixel columns;         
%                            PFFT = Power Fast Fourier Transformation; 
%                            i.e. the mean power of the lower half of frequencies is as big as  the mean power of the upper half,     A ratio of higher to lower frequencies i.e. the higher the half cut frequency, the more higher image frequencies
%                            Zero frequency is subtracted and power is multiplied by frequency
%   Row 30 or 50:    VertHalfCut  = Half cut frequency cutting the mean across all vertical frequency distributions; PFFT across each of the q or Width vertival pixel rows; 
%   Row 31 or 51:    MeanHalfCut = weighted mean of horizontal and vertical half cut frequencies (q x HorHalfCut + p x VertHalfCut) / (p+q) or (Width x HorHalfCut +  Height x VertHalfCut) / (Height+Width)
%   Row 32 or 52:    HorFita = a of best  f ^-a fit fitting the mean frequency distribution across all horizontal frequency distributions;
%                           A first and rough approximation of a frequency distribution of natural images is f ^-a, The bigger the a the more higher image freqencies,
%   Row 33 or 53:    VertFita = a of best  f ^-a fit fitting the mean frequency distribution across all vertical frequency distributions;
%   Row 34 or 54:    MeanFita = weighted mean of horizontal and vertical a values (q x HorFita + p x VertFita) / (p+q) or (Width x HorFita +  Height x VertFita) / (Height+Width)
%
%   Row 61-100:     Parameter for red part of the image
%   Row 61-80:       inclusive black border
%   Row 81-100:     exclusive black border
%
%   Row 101-140:    Parameter for green part of the image
%   Row 101-120:    inclusive black border
%   Row 121-140:    exclusive black border
%
%   Row 141-180:    Parameter for green part of the image
%   Row 141-160:    inclusive black border
%   Row 161-180:    exclusive black border


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


global FileMat



if nargin<4;CalcHsvStatus=0;end
if nargin<3;CalcAllSpatStatus=0;end
if nargin<2;SaveFilePath=[];end
if nargin<1;FileMat=[];end

 
if isempty(SaveFilePath)
    [SaveFile,SavePath]=uiputfile('PicParaAll.txt', 'Output file name:');
    SaveFilePath=[SavePath,SaveFile];
else
     Tmp=findstr(SaveFilePath,filesep);
      if isempty(Tmp)
	      SavePath=[];
	      SaveFile=SaveFilePath;
        else
	       SavePath=[SaveFilePath(1:Tmp(length(Tmp)))];
	       if length(SaveFilePath)>Tmp(length(Tmp))
		      SaveFile=[SaveFilePath(Tmp(length(Tmp))+1:length(SaveFilePath))];
	       else
		      SaveFile=[];
	       end
        end
    end
    
 Path='set 13-14 :IAPS 14 images:'
 First=1;
 for Ind=1000:9999;
    FilePath0=[Path,int2str(Ind),'.jpg']
    FilePath1=[Path,int2str(Ind),'.1.jpg'];
    FilePath2=[Path,int2str(Ind),'.2.jpg'];
    if exist(FilePath0)==2 
        if First
            First=0;
            FileMat=char(FilePath0);
        else
            FileMat=char(FileMat,FilePath0);
        end
    end
     if exist(FilePath1)==2 
        if First
            First=0;
            FileMat=char(FilePath1);
        else
            FileMat=char(FileMat,FilePath1);
        end
    end
     if exist(FilePath2)==2 
        if First
            FileMat=char(FilePath2);
            First=0;
        else
            FileMat=char(FileMat,FilePath2);
        end
    end
end
    
[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FileMat,'*.jpg','Choose a jpg or batch file:');


if NFiles==0; return; end


hPicFig=figure('Units','normal','Position',[0 .5 .5 .5], ...
                    'Name','Calculate Picture Parameter:','Color',[0 0 0], ...
                    'NumberTitle','off');
hSvdFig=figure('Units','normal','Position',[0 0 .25 .4],'Name','Singular value decomposition ','NumberTitle','off');
hSpatFrequFig=figure('Units','normal','Position',[.25 0 .25 .4],'Name','Spatial Frequency ','NumberTitle','off');
         
axis('off')

if CalcHsvStatus;  MaxColorInd=7; else;  MaxColorInd=4; end
NParaMat=20+MaxColorInd.*40;
ParaMat=zeros(NFiles,NParaMat);
TmpFilePath=[SavePath,'TmpJpg90.jpg']

for FileInd=1:NFiles	
       FilePath=deblank(FileMat(FileInd,:));
       Tmp=findstr(FilePath,filesep);
        if isempty(Tmp)
	       Path=[];
	       File=FilePath;
        else
	       Path=[FilePath(1:Tmp(length(Tmp)))];
	       if length(FilePath)>Tmp(length(Tmp))
		      File=[FilePath(Tmp(length(Tmp))+1:length(FilePath))];
	       else
		      File=[];
	       end
        end
	fprintf(['# ',int2str(FileInd),' of ',int2str(NFiles), ' ; Name: ',FilePath,'\n']);
       fid=fopen(FilePath); fseek(fid,0,1); Jpg100FileSize=ftell(fid); fclose(fid); %Size in Bit of JPG file without compression    
	UInt8ImMat=imread(FilePath,'jpg');
       imwrite(UInt8ImMat,TmpFilePath,'Quality',90);
       fid=fopen(FilePath); fseek(fid,0,1); Jpg90FileSize=ftell(fid); fclose(fid); %Size in Bit of JPG file with compression (90% Quality)
	[p,q,r]=size(UInt8ImMat);
        if r==1; %Black and white image
            UInt8ImMatTmp=zeros(p,q,3);
            for i=1:3
                UInt8ImMatTmp(:,:,i)=UInt8ImMat;
            end
            UInt8ImMat=UInt8ImMatTmp;
            clear UInt8ImMatTmp
        end    
                                                 %p=Total number of Pixel in vertical  direction  (inclusive black frame)
                                                 %q=Total number of Pixel in  horizontal direction (inclusive black frame)
	p2=floor(p./2);
	q2=floor(q./2);
	%========Calculate Real Picture Size (without black frame)===============
	[QInd]=find(sum(UInt8ImMat(p2,:,:),3));%Hor Pix
	MinQInd=min(QInd);
	MaxQInd=max(QInd);
	[PInd]=find(sum(UInt8ImMat(:,q2,:),3));%Vert Pix
	MinPInd=min(PInd);
	MaxPInd=max(PInd);
	LRel=(MinQInd-1)./q;
	RRel=MaxQInd./q;
	TRel=(MinPInd-1)./p;
	BRel=MaxPInd./p;
	Width=(MaxQInd-MinQInd+1);    %Number of Pixel in horizontal direction exclusive black frame
	Height=(MaxPInd-MinPInd+1);    %Number of Pixel in vertical direction exclusive black frame
	FullPicStatus=1;
	if Width~=q | Height~=p
		FullPicStatus=2;	
        end
	Height2Width=Height./Width;         %Relative verticallity (Height devided by Width)
       %Landscape or Portrait
	Land2Port=0;			%Quadrat 
	if Height2Width>1
		Land2Port=-1;		%Portrait
	elseif Height2Width<1
		Land2Port=1;		%Landscape
	end
       ParaMat(FileInd,1:8)=[q,p,Width,Height,Height2Width,Land2Port,Jpg100FileSize,Jpg90FileSize];
	for PicStatusInd=1:FullPicStatus        
		if PicStatusInd==1;   %FullPicStatus
			ImMatTmp=zeros(p,q,r);
			FFTImMat=zeros(p,q);
		elseif  PicStatusInd==2; 
			p=Height;
			q=Width;
			p2=floor(p./2);
			q2=floor(q./2);
			ImMatTmp=zeros(p,q,r);
			FFTImMat=zeros(p,q);
		end     
		for ColorInd=1:MaxColorInd
             		ParaMatIndex=20+(ColorInd-1).*40;
			if PicStatusInd==1; 
				PicFigName1='No Border; ';
			elseif  PicStatusInd==2; 
				PicFigName1='With Border; ';
			end
			figure(hPicFig); clf;
			if ColorInd==1; 
				ColorStr='B&W';
			elseif ColorInd==2; 
				ColorStr='Red';
			elseif ColorInd==3; 
				ColorStr='Green';
			elseif ColorInd==4; 
				ColorStr='Blue';
			elseif ColorInd==5; 
				ColorStr='Hue';
				UInt8ImMat=rgb2hsv(UInt8ImMat);
			elseif ColorInd==6; 
				ColorStr='Sat.';
			elseif ColorInd==7; 
				ColorStr='Value';
			end
			if ColorInd==1	%Black and White
				TmpInd=1;
				if PicStatusInd==1; 
			         	ImMatTmp(:,:,1)=mean(UInt8ImMat(:,:,:),3);
				elseif  PicStatusInd==2; 
					ImMatTmp(:,:,1)=mean(UInt8ImMat(MinPInd:MaxPInd,MinQInd:MaxQInd,:),3);
				end
				ImMatTmp(:,:,2)=ImMatTmp(:,:,1);
				ImMatTmp(:,:,3)=ImMatTmp(:,:,1);
			else
				if ColorInd<5
					TmpInd=ColorInd-1;
				else
					TmpInd=ColorInd-4;
				end
				if PicStatusInd==1; 
					ImMatTmp(:,:,TmpInd)=UInt8ImMat(:,:,TmpInd);
				elseif  PicStatusInd==2; 
					ImMatTmp(:,:,TmpInd)=UInt8ImMat(MinPInd:MaxPInd,MinQInd:MaxQInd,TmpInd);
				end
			end
                    %============================================================
		       if ColorInd<5
				ImMatTmp=ImMatTmp./255;
			end
			MeanVal=mean(mean(ImMatTmp(:,:,TmpInd)));	
			StdVal=std(std(ImMatTmp(:,:,TmpInd)));
                     imwrite(ImMatTmp,TmpFilePath,'Quality',100);
                     fid=fopen(TmpFilePath); fseek(fid,0,1); Jpg100FileSize=ftell(fid); fclose(fid);
                     imwrite(ImMatTmp,TmpFilePath,'Quality',90);
                     fid=fopen(TmpFilePath); fseek(fid,0,1); Jpg90FileSize=ftell(fid); fclose(fid);
                     if PicStatusInd==1
                       ParaMat(FileInd,ParaMatIndex+1)=MeanVal;      %Mean Brightness
 			  ParaMat(FileInd,ParaMatIndex+2)=StdVal;         %Mean Contrast
                       ParaMat(FileInd,ParaMatIndex+3)=Jpg100FileSize;
                       ParaMat(FileInd,ParaMatIndex+4)=Jpg90FileSize;
                     end
 		       ParaMat(FileInd,ParaMatIndex+21)=MeanVal;  %If PicStatusInd does not become 2 (full size pic) => Brightnes and Contrast of border pic identical to full size pic
 		       ParaMat(FileInd,ParaMatIndex+22)=StdVal;	   %If PicStatusInd becomes 2 (border pic) => Brightnes and Contrast of border pic overwrites full size pic values		
                     ParaMat(FileInd,ParaMatIndex+23)=Jpg100FileSize;
                     ParaMat(FileInd,ParaMatIndex+24)=Jpg90FileSize;
                     %============================================================
			PicFigName=[];
			PicFigName=[PicFigName1,'Mean ( ',num2str(round(MeanVal.*100)./100),') and Std. ( ',num2str(round(StdVal.*100)./100),') of ' ColorStr ' ; # ',int2str(FileInd),' of ',int2str(NFiles), ' ; File: ',File];
			set(hPicFig,'Name',PicFigName);
                     hPicAxes=axes('Units','Normal','Position',[0 0 1 1]);
                     image(ImMatTmp);
                     axis('off');
                     pause(.001)
                    
                     if ColorInd==1 | CalcAllSpatStatus	   %Black and White			
                     %====================SVD============================
                     figure(hSvdFig);	
 			FFTImMat(:,:)=ImMatTmp(:,:,TmpInd);
			S=svd(FFTImMat);
			MinNS=min(300,length(S));
			CumSumS=cumsum(S);
			SumS=sum(S);
                     RelSvd1=S(1)./SumS;
                     RelSvd5=sum(S(1:5))./SumS;
                     Svd25=min(find(CumSumS>.25.*SumS));
			Svd50=min(find(CumSumS>.50.*SumS));
                     plot(S,'k')
                     hold on
                     plot(Svd25,S(Svd25),'*b')
                     plot(Svd50,S(Svd50),'*g')
                     axis([1 min(MinNS,2.*Svd50) S(MinNS) S(1)])
                     hold off
                     SvdTitleString=['RelSvd 1: ',sprintf('%g',RelSvd1),'; RelSvd 5: ',sprintf('%g',RelSvd5),'; Svd25: ',sprintf('%g',Svd25),'; Svd50: ',sprintf('%g',Svd50)];	
                     set(hSvdFig,'Name',SvdTitleString)
                     pause(.001)
                    %====================FFT============================
                     FFTImMat(:,:)=ImMatTmp(:,:,TmpInd);
 			FFTImMat=fft2(FFTImMat);
 			FFTImMat=abs(FFTImMat.*conj(FFTImMat));
			figure(hPicFig); clf;
			PicFigName=[];
			PicFigName=[PicFigName1,'2D PFFT of ' ColorStr ' ; # ',int2str(FileInd),' of ',int2str(NFiles), ' ; File: ',File];
			set(hPicFig,'Name',PicFigName);
                     hPicAxes=axes('Units','Normal','Position',[0 0 1 1]);
 			image(FFTImMat);
 			axis('off')
		       pause(.001)
                     figure(hSpatFrequFig);	
                     Tmp2=100;
		       xVec=[2:Tmp2];
		       xIntVec=[.01:.01:Tmp2];
			MinPlot=inf;
                     MaxPlot=1;
                     SpatFrequTitleString=[];
			for HorVertInd=1:2
				if HorVertInd==1
					HorVertVec=sum(FFTImMat)./q;	
                                   SpatFrequTitleString='Hor.: ';
				else			
					HorVertVec=sum(FFTImMat')./p;
                                   SpatFrequTitleString='Vert.: ';
				end		
				HorVertVec=HorVertVec(xVec);	                               %Except mean
				IntHorVertVec=interp1(xVec,HorVertVec,xIntVec,'spline');
				NegIndVec=find(IntHorVertVec<0);
				IntHorVertVec(NegIndVec)=zeros(size(NegIndVec));
		            
				HorVertVec=HorVertVec./xVec.^-1;
				IntHorVertVec=IntHorVertVec./xIntVec.^-1;
				
				MaxHorVertVec=max(HorVertVec);
			       HorVertVec=HorVertVec./MaxHorVertVec;	             %Normalize
				MaxHorVertVec=1;
				MaxIntHorVertVec=max(IntHorVertVec);
				IntHorVertVec=IntHorVertVec./MaxIntHorVertVec;	%Normalize
				%=============Half Cut Frequency==========================
				SumVec=sum(IntHorVertVec);			
				CumSumVec=cumsum(IntHorVertVec);		
				DiffVec=CumSumVec-SumVec./2;
				[NonUse,MinInd]=min(abs(DiffVec));
				MinInd=xIntVec(MinInd);
				if HorVertInd==1
				       HorHalfCut=MinInd;	
				else			
					VertHalfCut=MinInd;
				end
				%=============Best x^-a fit==========================
				epsilon=.1;
				a=-0.3;
				FitValOld=inf;
				for i=1:3
					a=a+2.*epsilon;
					epsilon=10.^(-i);
					a=a+epsilon;
					NextStatus=1;
					while NextStatus
						a=a-epsilon;
						FitHorVertVec=xVec.^a;
 						FitValNew=sum(abs(FitHorVertVec-HorVertVec));
						if FitValNew>FitValOld
						     NextStatus=0;
						     FitValOld=inf;
						else
						     FitValOld=FitValNew;
						end
					end
				end
                            if HorVertInd==1
					HorFita=a;
				else			
					VertFita=a;	
				end
                            if HorVertInd==1
                                MeanHorVertVec=HorVertVec;
                                MeanFitHorVertVec=FitHorVertVec;
                           end
                      end	%for HorVertInd=1:2
                
                      MeanHorVertVec=(MeanHorVertVec+HorVertVec)./2;
                      MeanFitHorVertVec=(MeanFitHorVertVec+FitHorVertVec)./2;
                      MinPlot=min(MeanHorVertVec);
                      MaxPlot=max(MeanHorVertVec);
                      MeanHalfCut=(q.*HorHalfCut+p.*VertHalfCut)./(p+q);
                      MeanFita=-1.*(q.*HorFita+p.*VertFita)./(p+q);
                    	 SpatFrequTitleString=['Half Cut Frequ: f=',sprintf('%g',MinInd),'; Best x^-a fit: a=',sprintf('%g',round(MeanFita.*100)./100),'; '];
                     %==============Plot======================================
			semilogy(MeanHorVertVec,'b'); 
			hold on; 
			semilogy(MeanFitHorVertVec,'r');	
			semilogy(round([MeanHalfCut MeanHalfCut]),[MinPlot MaxPlot],'k')	
			xlabel('Spatial Frequ. [1/m]')
			ylabel('Amplitude []')
			axis([1 100 MinPlot MaxPlot])
			set(hSpatFrequFig,'Name',SpatFrequTitleString)
                     pause(0.001)
                     hold off
                     %=============ParaMat=====================================
                     if PicStatusInd==1  
                       ParaMat(FileInd,ParaMatIndex+5)=RelSvd1;   
                       ParaMat(FileInd,ParaMatIndex+6)=RelSvd5;  
                       ParaMat(FileInd,ParaMatIndex+7)=Svd25; 
                       ParaMat(FileInd,ParaMatIndex+8)=Svd50;
                       ParaMat(FileInd,ParaMatIndex+9)=HorHalfCut; 
                       ParaMat(FileInd,ParaMatIndex+10)=VertHalfCut; 
                       ParaMat(FileInd,ParaMatIndex+11)=MeanHalfCut; 
                       ParaMat(FileInd,ParaMatIndex+12)=HorFita; 
                       ParaMat(FileInd,ParaMatIndex+13)=VertFita; 
                       ParaMat(FileInd,ParaMatIndex+14)=MeanFita; 
                     end
                     ParaMat(FileInd,ParaMatIndex+25)=RelSvd1;   
                     ParaMat(FileInd,ParaMatIndex+26)=RelSvd5;  
                     ParaMat(FileInd,ParaMatIndex+27)=Svd25; 
                     ParaMat(FileInd,ParaMatIndex+28)=Svd50; 
                     ParaMat(FileInd,ParaMatIndex+29)=HorHalfCut; 
                     ParaMat(FileInd,ParaMatIndex+30)=VertHalfCut; 
                     ParaMat(FileInd,ParaMatIndex+31)=MeanHalfCut; 
                     ParaMat(FileInd,ParaMatIndex+32)=HorFita; 
                     ParaMat(FileInd,ParaMatIndex+33)=VertFita; 
                     ParaMat(FileInd,ParaMatIndex+34)=MeanFita; 
                     end %if ColorInd==1 | CalcAllSpatStatus
            end
      end
end

SaveFid1=fopen(SaveFilePath,'w');
SaveFid2=fopen([SaveFilePath,'.s'],'w');
Str1='File TotalWidth TotalHight RelWidth RelHeight Height2Width Land2Port Jpg100FileSize Jpg90FileSize';
fprintf(SaveFid1,'%s',Str1);
Str1='File TotalWidth TotalHight RelWidth RelHeight Jpg100FileSize ';
fprintf(SaveFid2,'%s',Str1);
for ColorInd=1:MaxColorInd
	if ColorInd==1; 
		ColorStr='B&W_';
	elseif ColorInd==2; 
		ColorStr='Red_';
	elseif ColorInd==3; 
		ColorStr='Green_';
	elseif ColorInd==4; 
		ColorStr='Blue_';
	elseif ColorInd==5; 
		ColorStr='Hue_';
	elseif ColorInd==6; 
		ColorStr='Sat_';
	elseif ColorInd==7; 
		ColorStr='Val_';
	end
       TotRelStr=' Tot_';
       Str2=[TotRelStr,ColorStr,'Brightness',TotRelStr,ColorStr,'Contrast',TotRelStr,ColorStr,'Jpg100FileSize', TotRelStr,ColorStr,'Jpg90FileSize'];
       Str3=[TotRelStr,ColorStr,'RelSvd1',TotRelStr,ColorStr,'RelSvd5',TotRelStr,ColorStr,'Svd25',TotRelStr,ColorStr,'Svd50'];
       Str4=[TotRelStr,ColorStr,'HorHalfCut',TotRelStr,ColorStr,'VertHalfCut',TotRelStr,ColorStr,'MeanHalfCut',TotRelStr,ColorStr,'HorFita',TotRelStr,ColorStr,'VertFita',TotRelStr,ColorStr,'MeanFita'];
       TotRelStr=' Rel_';
       Str5=[TotRelStr,ColorStr,'Brightness',TotRelStr,ColorStr,'Contrast',TotRelStr,ColorStr,'Jpg100FileSize', TotRelStr,ColorStr,'Jpg90FileSize'];
       Str6=[TotRelStr,ColorStr,'RelSvd1',TotRelStr,ColorStr,'RelSvd5',TotRelStr,ColorStr,'Svd25',TotRelStr,ColorStr,'Svd50'];
       Str7=[TotRelStr,ColorStr,'HorHalfCut',TotRelStr,ColorStr,'VertHalfCut',TotRelStr,ColorStr,'MeanHalfCut',TotRelStr,ColorStr,'HorFita',TotRelStr,ColorStr,'VertFita',TotRelStr,ColorStr,'MeanFita'];
       fprintf(SaveFid1,'%s',[Str2,Str3,Str4,Str5,Str6,Str7]);
       Str2=[ColorStr,'Brightness ',ColorStr,'Contrast ',ColorStr,'Jpg100FileSize '];
       fprintf(SaveFid2,'%s',Str2);
 end

 fprintf(SaveFid1,'\n');
 fprintf(SaveFid2,'\n');
 for FileInd=1:NFiles
      FilePath=FileMat(FileInd,:);
       Tmp=findstr(FilePath,filesep);
        if isempty(Tmp)
	       Path=[];
	       File=FilePath;
        else
	       Path=[FilePath(1:Tmp(length(Tmp)))];
	       if length(FilePath)>Tmp(length(Tmp))
		      File=[FilePath(Tmp(length(Tmp))+1:length(FilePath))];
	       else
		      File=[];
	       end
        end
       fprintf(SaveFid1,'%s\t',File);                                   %1
       fprintf(SaveFid1,'%g\t',ParaMat(FileInd,1:8));           %2-9
       fprintf(SaveFid2,'%s\t',File);                                   %1
       fprintf(SaveFid2,'%g\t',ParaMat(FileInd,[1,2,3,4,7]));  %2-6
       for ColorInd=1:MaxColorInd
            ParaMatIndex=20+(ColorInd-1).*40;
            fprintf(SaveFid1,'%g\t',ParaMat(FileInd,ParaMatIndex+1:ParaMatIndex+14));    %10-22
            fprintf(SaveFid1,'%g\t',ParaMat(FileInd,ParaMatIndex+21:ParaMatIndex+34));  %23-35
            fprintf(SaveFid2,'%g\t',ParaMat(FileInd,ParaMatIndex+1:ParaMatIndex+3));      %7-9
       end
   fprintf(SaveFid1,'\n');
   fprintf(SaveFid2,'\n');
end
fclose(SaveFid1);
fclose(SaveFid2);
return;
