%   CalcRawEcg.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


%=========================================================================================
FiltFilePath=which('High01.hf');
FiltMat=ReadData(FiltFilePath,1,[],'float64','float64');
HighA=FiltMat(1,:)
HighB=FiltMat(2,:)
                                                                     
%=========================================================================================
DefDataFilePath=SetDefPath('r','*.raw');
[File,Path,FilePath]=ReadFilePath([],DefDataFilePath);
SetDefPath('w',Path);
a0=ReadData(FilePath,1);
a1=(filtfilt(HighB,HighA,a0));
NPoints=length(a1);
NPoints2Plot=2000;

hRawEcg=figure('Units','normal','Position',[0 .7 1 .3],'Name','Raw ECG','Color',[1 1 1],'NumberTitle','off');
plot(a0)
axis([1, NPoints,min(a0),max(a0)])


% hGinput=figure('Units','normal','Position',[0 .4 1 .3],'Name','GInput','Color',[1 1 1],'NumberTitle','off');
% plot(a1(1:NPoints2Plot))
% [x,y,z]=ginput(2)
% b1=a1(round(x(1)):round(x(2)));
% c1=xcorr(a1,b1);
% c1=c1(1:NPoints);

c1=a1;
hPeak=figure('Units','normal','Position',[0 .3 1 .3],'Name','Filtered ECG','Color',[1 1 1],'NumberTitle','off');
plot(c1)
axis([1,NPoints,0,1.1.*max(c1)])

hold on
n1=[];
while 1
	[x,y,z]=ginput(1);
	if z==1
		m1=find(c1>y);
		n1(1)=m1(1);
		j=1;
		for i=2:length(m1)
			if m1(i)-m1(i-1)==1
				if c1(m1(i))>c1(n1(j));
					n1(j)=m1(i);					
				end
			else
				j=j+1;
				n1(j)=m1(i);
			end
		end
		plot(n1,c1(n1),'r*')
		hold off
		break;
	end		
end
figure(hRawEcg)
plot(c1)
axis([1,NPoints,0,1.1.*max(c1)])

plot(a0)
hold on
plot(n1,a0(n1),'r*')
hold off
axis([1,NPoints,1.1.*min(a0),1.1.*max(a0)])

SaveAscii(n1,[FilePath,'.p'])
return
% %=========================================================================================
% SampRate=1;
% ch_LowPassFilt=0;
% ch_HighPassFilt=1;
% HighDefFreqsMat=[SampRate 0.01 0.02];
% HighDefRipMat=[3 45];
% LowDefFreqsMat=[SampRate 10 20]; 
% LowDefRipMat=[3 45];
% 
% [ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat] = ...
% GetHighLowFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
% ch_LowPassFilt,ch_HighPassFilt);
% %=========================================================================================
%  FiltMat=zeros(2,length(HighB))
%  HighA
%  HighB
%  FiltMat(1,:)=HighA;
%  FiltMat(2,:)=HighB;
%  SaveData(FiltMat,'Rudi:ApplicationsOS9:Matlab5.2:Plot2d3d:Plot2dUtil:FilterCoeff:High01.hf',1,[],'float64','float64');
% return
