function [NewFileMat]=ChangeFileNames(FileMat,StrOld,StrNew)

%   ChangeFileNames

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3; StrNew=[]; end
if nargin<2; StrOld=[]; end
if nargin<1; FileMat=[]; end

StrOld='_3_'
StrNew='.1.1'

StrOld=IfEmptyInputString('Enter "OldString":',[],StrOld,'_1',1)
StrNew=IfEmptyInputString('Enter "NewString":',[],StrNew,'1.1',1)

if isempty(StrOld); return; end
if isempty(StrNew); return; end
NStrOld=length(StrOld);
NStrNew=length(StrNew);
   
DefDataFilePath=SetDefPath(1,'*');	
if isempty(FileMat)
	[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames([],DefDataFilePath,'Choose one file of target directory:',[],[],[],[],1);
	if NFiles==0; return; end
	[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
    Tmp=findstr(BatchPath,filesep)
    StrNew=['.',BatchPath(Tmp(end-1)+1:Tmp(end)-1)]
	[File,Path]=SepFilePath(deblank(FileMat));
	Tmp=dir(Path);
	NFiles=size(Tmp,1);
	FileMat=char([Path,Tmp(1).name]);
	for i=2:NFiles
		FileMat=char(FileMat,[Path,Tmp(i).name]);
	end
	disp(FileMat)
else
	[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames([],DefDataFilePath,'Choose files to rename:');
	if NFiles==0; return; end
	[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
end
SetDefPath(2,BatchPath);

NFileMatStr=size(FileMat,2);
NewFileMat=FileMat;
for FileInd=1:NFiles
	OldFilePath=deblank(FileMat(FileInd,:));
	[File,Path]=SepFilePath(OldFilePath);
	NStrFile=length(File);
	if NStrFile>NStrOld
		Tmp=findstr(File,StrOld)
		if ~isempty(Tmp)
			if Tmp(1)==1
				NewFile=[StrNew,File(NStrOld:NStrFile)];
			else
				NewFile=[File(1:Tmp(1)-1),StrNew,File(Tmp(1)+NStrOld:NStrFile)];
			end
			NewFilePath=[Path,NewFile];
            [CopyStatus,CopyMsg]=copyfile(OldFilePath,NewFilePath)
            if CopyStatus
                delete([OldFilePath])
            else
                fprintf(1,'Can not copy file:  to file NewFilePath\n')               
                disp(OldFilePath)
                fprintf(1,'to file:\n')   
                disp(NewFilePath)
                fprintf(1,'Copy Message:\n')  
                disp(CopyMsg)
            end
			NewFileMat(FileInd,1:length(NewFilePath))=NewFilePath;
			for i=length(NewFilePath)+1:NFileMatStr
				NewFileMat(FileInd,i)=' ';
			end
		end
	end
end
disp(NewFileMat)

StrOld='_3'
StrNew=[StrNew]

NStrOld=length(StrOld);
NStrNew=length(StrNew);

NFileMatStr=size(FileMat,2);
NewFileMat=FileMat;
for FileInd=1:NFiles
	OldFilePath=deblank(FileMat(FileInd,:));
	[File,Path]=SepFilePath(OldFilePath);
	NStrFile=length(File);
	if NStrFile>NStrOld
		Tmp=findstr(File,StrOld)
		if ~isempty(Tmp)
			if Tmp(1)==1
				NewFile=[StrNew,File(NStrOld:NStrFile)];
			else
				NewFile=[File(1:Tmp(1)-1),StrNew,File(Tmp(1)+NStrOld:NStrFile)];
			end
			NewFilePath=[Path,NewFile];
            [CopyStatus,CopyMsg]=copyfile(OldFilePath,NewFilePath)
            if CopyStatus
                delete([OldFilePath])
            else
                fprintf(1,'Can not copy file:  to file NewFilePath\n')               
                disp(OldFilePath)
                fprintf(1,'to file:\n')   
                disp(NewFilePath)
                fprintf(1,'Copy Message:\n')  
                disp(CopyMsg)
            end
			NewFileMat(FileInd,1:length(NewFilePath))=NewFilePath;
			for i=length(NewFilePath)+1:NFileMatStr
				NewFileMat(FileInd,i)=' ';
			end
		end
	end
end
disp(NewFileMat)

return;
