function[ParaVecOld,NewSetFilePath]=ChangeMsiSet(OldSetFilePath,NewSetFilePath,KeyWordMat,KeyWordFormat,ParaVecNew,StrMat)

%	ChangeMsiSet.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.     

if nargin<6; StrMat=[]; end
if nargin<5; 
	fprintf('[SetFilePath]=ChangeMsiSet(SetFilePath,KeyWordMat,ParaVec)');
	return;
end
NKeyWords=size(KeyWordMat,1);
NStr=size(StrMat,1);
if NKeyWords~=length(ParaVecNew)+NStr
	fprintf('NKeyWords~=length(ParaVec) in ChangeMsiSet');
	return;
end

File=[];
Path=[];
String='Choose MSI set file:';
[DefPath]=SetDefPath(1,'*.set');
[SetFile,SetPath,SetFilePath]=ReadFilePath(OldSetFilePath,DefPath,String);
SetDefPath(2,SetPath);
if SetFile==0; MsiFilePath=[]; return; end
if exist(SetFilePath,'file')~=2
	Message=char('Sorry,');
	Message=char(Message,'unable to find MSI set file:');
	Message=char(Message,'');
	Message=char(Message,[OldSetFilePath]);
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info','help'); 
	return;
end
if isempty(NewSetFilePath)
	NewSetFilePath=[OldSetFilePath,'.new'];
end

OldSetFid=fopen(OldSetFilePath,'rt');
NewSetFid=fopen(NewSetFilePath,'wt');
sKeyWordFormatVec=findstr(KeyWordFormat,'s');
while feof(OldSetFid) == 0
   	Line=fgetl(OldSetFid);
	for KeyWordInd=1:NKeyWords
		Keyword=deblank(KeyWordMat(KeyWordInd,:));
		Matches=findstr(Line,Keyword);
		Num=length(Matches);
		if Num>0
            if strcmp(KeyWordFormat(KeyWordInd),'d')
			    TestLine=sprintf(['%s\t%%',KeyWordFormat(KeyWordInd)],Keyword);
	    	    ParaVecOld(KeyWordInd)=sscanf(Line,TestLine,1);
			    Tmp=findstr(Line,int2str(ParaVecOld(KeyWordInd)));
			    Line=[Line(1:Tmp-1),int2str(ParaVecNew(KeyWordInd))];
            elseif strcmp(KeyWordFormat(KeyWordInd),'s')
                StrMatInd=find(sKeyWordFormatVec==KeyWordInd);
                fprintf(NewSetFid,'%s',Keyword);
                Line=deblank(StrMat(StrMatInd,:));
                if ~isempty(Line)
                    fprintf(NewSetFid,'\t');   
                end
            end
		end
	end
	fprintf(NewSetFid,'%s\n',Line);
end

fclose(OldSetFid);
fclose(NewSetFid);

return;
