function[TimeIndVec,NoTimeIndVec,TimeStatusVec,NInt,IntStartVec,IntEndVec]=...
	ChooseTimeIndNew(ch_ChooseTimeInd,TimeIndVec,NoTimeIndVec,TimeStatusVec,NPoints)
	
%	ChooseTimeIndNew.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<5; NPoints=[]; end
if nargin<4; TimeStatusVec=[]; end
if nargin<3; NoTimeIndVec=[]; end
if nargin<2;TimeIndVec=[]; end
if nargin<1; ch_ChooseTimeInd=[]; end


[ch_ChooseTimeInd]=IfEmptyInputBo('Do you want to choose special time points ? Y/N',...
[],ch_ChooseTimeInd,0,0);

if isempty(TimeIndVec) & isempty(NoTimeIndVec) & isempty(TimeStatusVec) & ~isempty(NPoints)
	if ~ch_ChooseTimeInd
		TimeIndVec=[1:NPoints]'; 
		NoTimeIndVec=[]; 
		TimeStatusVec=ones(NPoints,1); 
		NInt=1; 
		IntStartVec=1; 
		IntEndVec=NPoints; 
		return; 
	end
end
if isempty(TimeIndVec) & isempty(NoTimeIndVec) & ~isempty(TimeStatusVec)
	TimeIndVec=find(TimeStatusVec==1);
	NoTimeIndVec=find(TimeStatusVec==0);
	NPoints=length(TimeStatusVec);
	if TimeStatusVec(1)==1
		IntStartVec(1)=1;
		NInt=1;
	else
		NInt=0;
	end	
	for TimeIndex=2:NPoints
		if TimeStatusVec(TimeIndex-1)==0 & TimeStatusVec(TimeIndex)==1
			NInt=NInt+1;
			IntStartVec(NInt)=TimeIndex;
		end
	end
	NInt=0;
	for TimeIndex=1:NPoints-1
		if TimeStatusVec(TimeIndex)==1 & TimeStatusVec(TimeIndex+1)==0
			NInt=NInt+1;
			IntEndVec(NInt)=TimeIndex;
		end
	end
	if TimeStatusVec(NPoints)==1
		NInt=NInt+1;
		IntEndVec(NInt)=NPoints;
	end
	return;
end
NextInt=1;NInt=0;
TimeStatusVec=zeros(NPoints,1);
while NextInt
	NInt=NInt+1;
	fprintf('Choose time intervalls:\n');clc;
	fprintf(1,'Start of %g intervall:\n\n',NInt);
	[StartPoint]=IfEmptyInputValInt([],[],[],1,1,NPoints-1);
	fprintf('\n');clc;
	fprintf(1,'End of %g intervall:\n\n',NInt);
	[EndPoint]  =IfEmptyInputValInt([],[],[],NPoints,StartPoint,NPoints);
	TimeStatusVec(StartPoint:EndPoint)=ones(EndPoint-StartPoint+1,1);
	if NInt==1
		hfig=figure('Units','normal','NumberTitle','off','Position',[0,.5,.5,.5],'Name','Chosen intervall:')
	else
		clf;
	end		
	plot(TimeStatusVec)
	title('Chosen intervall:');
	xlabel('Points of time');
	[NextInt]=IfEmptyInputBo('Do you want to take one more intervall ?',[],[],0,0);
	if ~NextInt; TimeIndVec=find(TimeStatusVec==1); NoTimeIndVec=find(TimeStatusVec==0); end
end
if TimeStatusVec(1)==1
	IntStartVec(1)=1;
    NInt=1;
else
	NInt=0;
end
for TimeIndex=2:NPoints
	if TimeStatusVec(TimeIndex-1)==0 & TimeStatusVec(TimeIndex)==1
		NInt=NInt+1;
		IntStartVec(NInt)=TimeIndex;
	end
end
NInt=0;
for TimeIndex=1:NPoints-1
	if TimeStatusVec(TimeIndex)==1 & TimeStatusVec(TimeIndex+1)==0
		NInt=NInt+1;
		IntEndVec(NInt)=TimeIndex;
	end
end
if TimeStatusVec(NPoints)==1
	NInt=NInt+1;
	IntEndVec(NInt)=NPoints;
end
close(hfig);
return;


