%	FilterBatch.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


%==================================================================

[NFiles,FileMat]=ReadFileNames([],'*.at*','Choose *.at* file(s):');
if NFiles==0; return; end

%===============FilterFile====================================
SampRateTmp=250;
ChLowPassFilt=1;
ChHighPassFilt=1;
HighDefFreqsMat=[SampRateTmp 2 0];
HighDefRipMat=[3 25];
LowDefFreqsMat=[SampRateTmp 20 25]; 
LowDefRipMat=[3 45];

[ChLowPassFilt,LowB,LowA,ChHighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat] = ...
GetHighLowFiltCoeff(SampRateTmp,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
ChLowPassFilt,ChHighPassFilt);

if ChLowPassFilt | ChHighPassFilt
	for FileInd=1:NFiles
		[NoUse,NoUse,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
		SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec]=ReadAvgFile(FilePath);
		[NChan,NPoints]=size(AvgMat);
		if SampRate==SampRateTmp;
			if ChLowPassFilt
				for i=1:NChan
					AvgMat(i,:)=(filtfilt(LowB,LowA,AvgMat(i,:)'))';
				end
			end
			if ChHighPassFilt
				for i=1:NChan
					AvgMat(i,:)=(filtfilt(HighB,HighA,AvgMat(i,:)'))';
				end
			end
		end
		SaveAvgFile([FilePath '.f'],AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec);
	end
end

