%   FindLateralizedPeaks.m
%
%   Searchs for the two maxima lateralized peaks and determines their position and amplitude;
%   then finds the value on the middle line (x=0) between them and evaluates the difference 
%   between that vale and the mean amplitude of the two peaks.
%
%   this function has been written to evaluate how different sensors configurations and data anlyses                                                                    
%   differentiate between two artificial sources located simmetrically in the two emispheres.


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Andrea De Cesarei, Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  



global ScalpLoc
global OutData

wdata=[ScalpLoc OutData];


RightScalpLoc=wdata(find(wdata(:,1)<0),:);
LeftScalpLoc=wdata(find(wdata(:,1)>0),:);
MiddleScalpLoc=wdata(find(wdata(:,1)==0),:);

[MaxRightSide, iR]=max(RightScalpLoc(:,4));
fprintf('Maximum value on the right side is');
disp(MaxRightSide);
fprintf('at position\n');
fprintf('\nx = ');
disp(RightScalpLoc(iR,1));
fprintf('\ny = ');
disp(RightScalpLoc(iR,2));
fprintf('\nz = ');
disp(RightScalpLoc(iR,3));

[MaxLeftSide, iL]=max(LeftScalpLoc(:,4));
fprintf('Maximum value on the Left side is');
disp(MaxLeftSide);
fprintf('at position\n');
fprintf('\nx = ');
disp(LeftScalpLoc(iL,1));
fprintf('\ny = ');
disp(LeftScalpLoc(iL,2));
fprintf('\nz = ');
disp(LeftScalpLoc(iL,3));


%only top and bottom!!!!!!!!!
% [MaxMiddleSide, i]=max(MiddleScalpLoc(:,4));
% fprintf('Maximum value on the Middle line is');
% disp(MaxMiddleSide);
% fprintf('at position\n');
% fprintf('\nx = ');
% disp(MiddleScalpLoc(i,1));
% fprintf('\ny = ');
% disp(MiddleScalpLoc(i,2));
% fprintf('\nz = ');
% disp(MiddleScalpLoc(i,3));

% first finds, for the y and z axes, the mean of the two points (the x is not necessary because 
% the constraint for the x dimension is that the point is near to the 0
Y_Mean=mean([RightScalpLoc(iR,2); LeftScalpLoc(iL,2)]);
Z_Mean=mean([RightScalpLoc(iR,3); LeftScalpLoc(iL,3)]);

%identifies the point nearest to the middle line on the right side

DifScalpLoc=[(RightScalpLoc(:,1)) (RightScalpLoc(:,2)-Y_Mean) (RightScalpLoc(:,3)-Z_Mean)];

SqDifScalpLoc=DifScalpLoc.^2;

SumSqDifScalpLoc=SqDifScalpLoc(:,1)+SqDifScalpLoc(:,2)+SqDifScalpLoc(:,3);

[dummy, RightIndApprox]=min(SumSqDifScalpLoc);

%fprintf('Right point nearest to the middle line and near to the peak :');
%disp(RightScalpLoc(RightIndApprox, 1:4))

%identifies the point nearest to the middle line on the Left side

DifScalpLoc=[(LeftScalpLoc(:,1)) (LeftScalpLoc(:,2)-Y_Mean) (LeftScalpLoc(:,3)-Z_Mean)];

SqDifScalpLoc=DifScalpLoc.^2;

SumSqDifScalpLoc=SqDifScalpLoc(:,1)+SqDifScalpLoc(:,2)+SqDifScalpLoc(:,3);

[dummy, LeftIndApprox]=min(SumSqDifScalpLoc);

%fprintf('Left point nearest to the middle line and near to the peak :');
%disp(LeftScalpLoc(LeftIndApprox, 1:4))



%calculates the difference of the mean 

MiddleValue=mean([RightScalpLoc(RightIndApprox, 4); LeftScalpLoc(LeftIndApprox, 4)])
PeakAvgValue=mean([MaxRightSide; MaxLeftSide]);
%fprintf('Mean of the peaks :');
%disp(PeakAvgValue);

Peak2MiddleDiff=PeakAvgValue-MiddleValue;
fprintf('Difference Middle-Peak :');
disp(Peak2MiddleDiff);
