function[OutFilePath]=FlipAvgFiles(InFileMat,OutFilePath,chWeight,DefFileMask)

%   FlipAvgFiles

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<4; DefFileMask='*at*'; end;
if nargin<3; chWeight=[]; end;
if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;

%==================================================================

[DefFilePath] = SetDefPath(1,DefFileMask);
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Avg files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

for FileIndex=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	OutFilePath1=[Path,'AbsLR',File];
	OutFilePath2=[Path,'FlipLR',File];
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
	AvgMat=abs(AvgMat);
	FlipAvgMat=AvgMat;
	StdMat=abs(StdMat);
	FlipStdMat=StdMat;
	FlipMat=[ 	127 126;
				22	14;
				26	8;
				128 125;
				33	1;
				23 	9;
				18	15;
				27	2;
				19	10;
				24	3;
				39	121;
				34	122;
				28	123;
				25	124;
				20	4;
				44	120;
				49	114;
				45	115;
				40	116;
				35	117;
				29	118;
				21	119;
				12	5;
				13	113;
				30	112
				36	111;
				41	110;
				46	109;
				49	114;
				42	104;
				37	105;
				31	106;
				7	107;
				32	81;
				38	88;
				43	94;
				48	99;
				47	103;
				50	102;
				51	98;
				52	93;
				53	87;
				54	80;
				61	79;
				60	86;
				67	78;
				59	92;
				58	97;
				57	101;
				56	108;
				63	100;
				64	96;
				65	91;
				66	85;
				72	77;
				71	84;
				70	90;
				69	95;
				75	83;
				74	89];
	for i=1:size(FlipMat,1)
		FlipAvgMat(FlipMat(i,1),:)=AvgMat(FlipMat(i,2),:);
		FlipAvgMat(FlipMat(i,2),:)=AvgMat(FlipMat(i,1),:);
		FlipStdMat(FlipMat(i,1),:)=StdMat(FlipMat(i,2),:);
		FlipStdMat(FlipMat(i,2),:)=StdMat(FlipMat(i,1),:);
	end
	SaveAvgFile(OutFilePath1,AvgMat,NTrialAvgVec,StdMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
	SaveAvgFile(OutFilePath2,FlipAvgMat,NTrialAvgVec,FlipStdMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);

end



return;
