function [LR,Fs,WavFilePath]=GenNarrowBandWavFile(Fs,Duration,LowFrequ,HighFrequ,FlaPoints,IfftStatus,SoundStatus,PlotStatus,SaveStatus,WavPath)

%   GenNarrowBandWavFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<10; WavPath=[]; end
if nargin<9; SaveStatus=[]; end
if nargin<8; PlotStatus=[]; end
if nargin<7; SoundStatus=[]; end
if nargin<6; IfftStatus=[]; end
if nargin<5; FlaPoints=[]; end
if nargin<4; HighFrequ=[]; end
if nargin<3; LowFrequ=[]; end
if nargin<2; Duration=[]; end
if nargin<1; Fs=[]; end

if isempty(Fs); Fs=44100; end
if isempty(Duration); Duration=1; end
if isempty(LowFrequ); LowFrequ=500; end
if isempty(HighFrequ); HighFrequ=1000; end
if isempty(FlaPoints); FlaPoints=floor(Fs./100); end
if isempty(IfftStatus); IfftStatus=1; end
if isempty(SoundStatus); SoundStatus=1; end
if isempty(PlotStatus); PlotStatus=1; end
if isempty(SaveStatus); SaveStatus=0; end
if isempty(WavPath); 
    [DefFilePath,DefPath]=SetDefPath('r');
end

Nyquist=floor(Fs./2);
NPoints=floor(Fs.*Duration);
Duration=NPoints./Fs
FrequResol=Fs./NPoints;
xPlot=linspace(0,Nyquist,NPoints./2);

if IfftStatus   %ifft
    Tmp=zeros(NPoints,1);
    LowFrequPoint=LowFrequ.*NPoints./Fs;
    HighFrequPoint=HighFrequ.*NPoints./Fs;
    Tmp2=randn(HighFrequPoint-LowFrequPoint+1,1);
    Tmp(LowFrequPoint:HighFrequPoint)=Tmp2;
    Tmp=real(ifft(Tmp));
else            %butter filter
    N=4;
    Tmp=rand(NPoints,1);
    [B,A]=butter(N,[LowFrequ./Nyquist HighFrequ./Nyquist]);
    Tmp=filtfilt(B,A,Tmp);
end
Tmp=Tmp./(1.1.*max(Tmp));
LR=zeros(NPoints,2);
LR(:,1)=Tmp;
LR(:,2)=Tmp;

% windowing with hanning of FlaPoint slope length
w=hanning(FlaPoints.*2);
WinVec=ones(NPoints,1);
WinVec(1:FlaPoints)=w(1:FlaPoints);
WinVec(NPoints-FlaPoints+1:NPoints)=w(FlaPoints+1:FlaPoints.*2);

LR(:,1)=LR(:,1).*WinVec;
LR(:,2)=LR(:,2).*WinVec;

if PlotStatus
    %LR(:,1)=sin(linspace(0,2*pi*Duration*1000,NPoints))'; LR(:,2)=LR(:,1);   %Test: f=1000Hz
    subplot(3,1,1)
    plot(LR(1:FlaPoints,1));
    subplot(3,1,2)
    plot(LR(:,1));
    FFTLR=fft(LR);
    %PFFTLR=abs(FFTLR.*conj(FFTLR))./NPoints;
    PFFTLR=sqrt(real(FFTLR).*real(FFTLR)+imag(FFTLR).*imag(FFTLR))./(NPoints./2);
    PFFTLRPlot=PFFTLR(1:floor((length(PFFTLR)+1)./2));
    subplot(3,1,3)
    length(xPlot)
    length(PFFTLRPlot)
    plot(xPlot,PFFTLRPlot)
    axis([0 5000 0 1.1.*max(PFFTLRPlot)])
end
if SoundStatus
    Sound(LR,Fs)
end
if SaveStatus
    WaveFilePath=[WavPath,'Fs',int2str(Fs./1000),'-S',int2str(Duration),'-f',int2str(LowFrequ),'-',int2str(HighFrequ),'.wav'];
    wavwrite(LR,Fs,16,WaveFilePath);
else
    WavFilePath=[];
end

return;
