function GenSinWavFile(Fs,Duration,Frequ,FlaPoints,WaveFile)

%   GenSinWavFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.       

if nargin<5; WaveFile=[]; end
if nargin<4; FlaPoints=[]; end
if nargin<3; Frequ=[]; end
if nargin<2; Duration=[]; end
if nargin<1; Fs=[]; end


if isempty(Fs); Fs=48000; end
if isempty(Duration); Duration=2; end
if isempty(Frequ); Frequ=800; end
if isempty(WaveFile); WaveFile=[int2str(Fs),'_',int2str(Duration),'_',int2str(Frequ),'.wav']; end
WaveFile=WaveFile
NPoints=floor(Fs.*Duration);
FlaPoints=480;
if isempty(FlaPoints); FlaPoints=floor(NPoints/10); end
NFrequ=10;
Tmp=zeros(NPoints,1);
RandPhase=pi./randperm(NFrequ);
RandPhase=zeros(NFrequ,1);
for FrequInd=1:NFrequ 
    Tmp=Tmp+sin(linspace(RandPhase(FrequInd),Duration.*Frequ.*2.*pi+RandPhase(FrequInd),NPoints))';
    Frequ=Frequ+50;
end
Tmp=Tmp./(1.1.*max(max(Tmp)));
LR=zeros(NPoints,2);
LR(:,1)=Tmp;
LR(:,2)=Tmp;

w=hanning(FlaPoints.*2);
WinVec=ones(NPoints,1);
WinVec(1:FlaPoints)=w(1:FlaPoints);
WinVec(NPoints-FlaPoints+1:NPoints)=w(FlaPoints+1:FlaPoints.*2);
LR(:,1)=LR(:,1).*WinVec;
LR(:,2)=LR(:,2).*WinVec;
%figure
subplot(2,1,1)
plot(LR(1:2.*FlaPoints,1));
subplot(2,1,2)
plot(LR(1:4800,1));
nbits=16;
%wavwrite(LR,Fs,nbits,WaveFile);

%[Y,Fs,NBits]=wavread(WaveFile);
Sound(LR,Fs)
return;
