function [ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,ch_StopFilt,StopB,StopA,LowFreqsMat,HighFreqsMat,StopFreqsMat,LowRipMat,...
        HighRipMat,StopRipMat,LowFiltType,HighFiltType,StopFiltType,LowFiltOrder,HighFiltOrder,StopFiltOrder] = GetHighLowStopFiltCoeff(...
        SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,StopDefFreqsMat, ...
        StopDefRipMat, ch_LowPassFilt, ch_HighPassFilt, ch_StopFilt, FunctionStatus)
        
%   GetHighLowStopFiltCoeff
% 
%   See also PREPRO, GETLOWFILTCOEFF, GETHIGHFILTCOEFF, GETSTOPFILTCOEFF. 

%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.

global num den FreqsMat LowFiltOrder LowFiltType LowRipMat HighFiltOrder HighFiltType HighRipMat StopFiltOrder StopFiltType StopRipMat 
FiltType = [];
hFiltFig=[];    

HighFiltType = [];
HighFiltOrder = [];
HighRipMat = [];   

LowFiltType = [];
LowFiltOrder = [];
LowRipMat = [];

StopFiltType = [];
StopFiltOrder = [];
StopRipMat = [];   

if nargin<11; FunctionStatus = 0;end;

if nargin<10; ch_StopFilt=[]; end;
if nargin<9; ch_HighPassFilt=[]; end;
if nargin<8; ch_LowPassFilt=[]; end;

if nargin<7; StopDefRipMat=[]; end;
if nargin<6; StopDefFreqsMat=[]; end;
if nargin<5; LowDefRipMat=[]; end;
if nargin<4; LowDefFreqsMat=[]; end;
if nargin<3; HighDefRipMat=[]; end;
if nargin<2; HighDefFreqsMat=[]; end;
if nargin<1; SampRate=[]; end;



[SampRate]=IfEmptyInputSpecVal(SampRate,[125 250],[250],['Please insert the sampling rate:']);

if isempty(HighDefRipMat); HighDefRipMat=[3 45]; end
if isempty(HighDefFreqsMat); HighDefFreqsMat=[SampRate 5 2]; end
if isempty(LowDefRipMat); LowDefRipMat=[3 45]; end
if isempty(LowDefFreqsMat); LowDefFreqsMat=[SampRate 40 50]; end
if isempty(StopDefRipMat); LowDefRipMat=[3 5]; end
if isempty(StopDefFreqsMat); LowDefFreqsMat=[SampRate 49 51]; end

[ch_LowPassFilt]=IfEmptyInputBo(['Do you want to filter channels lowpass ?'],[],ch_LowPassFilt,1,1);
if ch_LowPassFilt
	[num,den,FreqsMat,hFigure,LowRipMat,LowFiltType,LowFiltOrder]=GetLowFiltCoeff('initialize',[],LowDefFreqsMat,LowDefRipMat,FunctionStatus);
	waitfor(hFigure);
	LowB=num;
	LowA=den;
	LowFreqsMat=FreqsMat;
else
	LowB=[];
	LowA=[];
	LowFreqsMat=[];
end
[ch_HighPassFilt]=IfEmptyInputBo(['Do you want to filter channels highpass ?'],[],ch_HighPassFilt,1,1);
if ch_HighPassFilt
	[num,den,FreqsMat,hFigure,HighRipMat,HighFiltType,HighFiltOrder]=GetHighFiltCoeff('initialize',[],HighDefFreqsMat,HighDefRipMat,FunctionStatus);
	waitfor(hFigure);
	HighB=num;
	HighA=den;
	HighFreqsMat=FreqsMat;
else
	HighB=[];
	HighA=[];
	HighFreqsMat=[];
end
[ch_StopFilt]=IfEmptyInputBo(['Do you want to filter channels stop-band?'],[],ch_StopFilt,1,1);
if ch_StopFilt
	[num,den,FreqsMat,hFigure,StopRipMat,StopFiltType,StopFiltOrder]=GetStopFiltCoeff('initialize',[],StopDefFreqsMat,StopDefRipMat,FunctionStatus);
	waitfor(hFigure);
	StopB=num;
	StopA=den;
	StopFreqsMat=FreqsMat;
else
	StopB=[];
	StopA=[];
	StopFreqsMat=[];
end
return
