function [OutFilePath] = Ind2Con(InFileMat)

%	Ind2Con.m
%
%	Makes CON out of i* files (index files as output of AvgApprox.m)

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<1; InFileMat=[]; end

[DefFilePath] = SetDefPath(1,'*.i*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Index files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

[OutFile,OutPath,OutFilePath]=WriteFilePath([BatchFile(1:findstr(BatchFile,'.i')) 'CON'],'Choose the new file name:');
if OutFile==0; return; end
SumNTrialsOld=0;CondMat=[];
%==================================================================
for FileIndex=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[Vec] = ReadData(FilePath,1,[],'ascii','ascii');
	[NTrials,NoUse]=size(Vec);
	SumNTrials=SumNTrialsOld+NTrials;
	CondMatTmp=zeros(SumNTrials,2);
	if ~isempty(CondMat)
		CondMatTmp(1:SumNTrialsOld,:)=CondMat;
	end
	CondMatTmp(SumNTrialsOld+1:SumNTrials,1)=FileIndex.*ones(NTrials,1);
	CondMatTmp(SumNTrialsOld+1:SumNTrials,2)=Vec;
	SumNTrialsOld=SumNTrials;
	CondMat=CondMatTmp;
end
SaveData(CondMat',OutFilePath,1,[],'ascii','ascii');
