function[OutFilePath]=MergeAppFiles(InFileMat,OutFilePath,chWeightStd)

%	MergeAppFiles.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<3; chWeightStd=[]; end;
if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;

%==================================================================
DefFilePath=SetDefPath('r','*.app*');
[NFiles,InFileMat,VersionString,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose *.app* files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath('w',BatchPath);
if NFiles<1; return; end
if isempty(OutFilePath)
	[OutFile,OutPath,OutFilePath]=WriteFilePath('Merge.appg','Choose output file name:');
end
if OutFile==0; return; end
if NFiles<2; return; end
NTrialsMerge=0;
NTrialsVec=zeros(NFiles,1);
for FileIndex=1:NFiles
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	InFid=fopen(InFilePath,'r','b');
	Version=fread(InFid,1,'int16');
	LHeader=fread(InFid,1,'int16');
	ScaleBins=fread(InFid,1,'int16');
	NChan=fread(InFid,1,'int16');
	NPoints=fread(InFid,1,'int16');
	NTrials=fread(InFid,1,'int16');
	SampRate=fread(InFid,1,'int16');
	AvgRefStatus=fread(InFid,1,'int16');
	if Version>1
		EegMegStatus=fread(InFid,1,'int16');
		NChanExtra=fread(InFid,1,'int16');
	else
		EegMegStatus=1;
		NChanExtra=0;
	end
	if FileIndex==1; 
		VersionOld=Version;
		ScaleBinsOld=ScaleBins;
		LHeaderOld=LHeader;
		NChanOld=NChan; 
		NPointsOld=NPoints; 
		SampRateOld=SampRate;
		AvgRefStatusOld=AvgRefStatus;
		EegMegStatusOld=EegMegStatus;
		NChanExtraOld=NChanExtra;
	end
	if VersionOld~=Version | LHeaderOld~=LHeader | ScaleBinsOld~=ScaleBins | ...
		NChanOld~=NChan | NPointsOld~=NPoints | SampRateOld~=SampRate | ...
		AvgRefStatusOld~=AvgRefStatus | EegMegStatusOld~=EegMegStatus | NChanExtraOld~=NChanExtra
		error('Header values do not agree'); 
	end
	NTrialsVec(FileIndex)=NTrials;
	NTrialsMerge=NTrialsMerge+NTrials;
	fclose(InFid);
end

OutFid=fopen(OutFilePath,'w');
fwrite(OutFid,Version,'int16');
fwrite(OutFid,LHeader,'int16');
fwrite(OutFid,ScaleBins,'int16');
fwrite(OutFid,NChan,'int16');
fwrite(OutFid,NPoints,'int16');
fwrite(OutFid,NTrialsMerge,'int16');
fwrite(OutFid,SampRate,'int16');
fwrite(OutFid,AvgRefStatus,'int16');
fwrite(OutFid,EegMegStatus,'int16');
fwrite(OutFid,NChanExtra,'int16');
OutTell=ftell(OutFid);
ZeroVec=zeros(LHeader-OutTell,1);
fwrite(OutFid,ZeroVec,'int8');
NTotTrials=sum(NTrialsVec);
for FileIndex=1:NFiles
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	fprintf(1,'Actual file: %g\n',FileIndex)
	fprintf(1,'Total files: %g\n',NFiles)
	fprintf(1,'Total trials: %g\n',NTotTrials)
	fprintf(1,'Trials in file: %g\n',NTrialsVec(FileIndex))
	fprintf(1,InFilePath)
	fprintf(1,'\n\n');
	InFid=fopen(InFilePath,'r');
	fseek(InFid,LHeader,'bof');
	for TrialInd=1:NTrials
		InMat=fread(InFid,[NChan,NPoints],'int16');
		fwrite(OutFid,InMat,'int16');
	end
	fclose(InFid);
end
fclose(OutFid);
return;
